/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class SubscriptionManagerRPImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP>
implements SubscriptionManagerRP {

	private static final long serialVersionUID = 1L;
	private static Logger log = Logger.getLogger(SubscriptionManagerRPImpl.class.getName());

	private EndpointReferenceType eprConsumer = null;
		
	public SubscriptionManagerRPImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP model,
			final AbstractSchemaElementImpl<?> parent) throws WSNotificationException{
		super(model,parent);
		
		try {
			if (model.getConsumerReference() != null)
				this.eprConsumer = new EndpointReferenceTypeImpl(model.getConsumerReference(),this);
		} catch (WSAddressingException e) {
			throw new WSNotificationException(e);			
		}
	}

	public EndpointReferenceType getConsumerReference() throws WSNotificationException {
		return this.eprConsumer;
	}

	public Date getCreationTime() {		
		XMLGregorianCalendar objFromModel = this.model.getCreationTime();
		return (objFromModel != null) ?objFromModel.toGregorianCalendar().getTime() : null;
	}

	public FilterType getFilter() {		
		com.ebmwebsourcing.wsstar.notification.definition.base.FilterType objFromModel = this.model.getFilter(); 
		return (objFromModel != null)? new FilterTypeImpl(objFromModel,null) : null;				
	}

	public SubscriptionPolicyType getSubscriptionPolicy() {		
		com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType objFromModel = this.model.getSubscriptionPolicy(); 
		return (objFromModel != null)? new SubscriptionPolicyTypeImpl(this.model.getSubscriptionPolicy(), this) : null;		
	}

	public void setConsumerReference(EndpointReferenceType ref) {	
		if(ref != null) {
			((AbstractSchemaElementImpl)ref).setParent(this);
			this.eprConsumer = ref;
			this.model.setConsumerReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl)ref).getModel());	
		}
	}

	public void setCreationTime(Date value) throws WSNotificationException {
		if(value != null) {
			GregorianCalendar gCalendar = new GregorianCalendar();
			gCalendar.setTime(value);        
			XMLGregorianCalendar xmlCalendar;

			try {
				xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
				this.model.setCreationTime(xmlCalendar);                         
			} catch (DatatypeConfigurationException e) {
				throw new WSNotificationException(e);
			}       
		}
	}

	public void setFilter(FilterType value) {
		if(value != null) {
			((AbstractSchemaElementImpl)value).setParent(this);
			this.model.setFilter((com.ebmwebsourcing.wsstar.notification.definition.base.FilterType) ((AbstractSchemaElementImpl)value).getModel());		
		}
	}

	public void setSubscriptionPolicy(SubscriptionPolicyType value) {
		if(value != null) {
			((AbstractSchemaElementImpl)value).setParent(this);
			this.model.setSubscriptionPolicy((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType) ((AbstractSchemaElementImpl)value).getModel());		
		}
	}
}
