/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.inout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.WsnbrConstants;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.topics.WstopConstants;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationJAXBContext;

/**
 * This class provides a collection of methods that enable conversion of a
 * "WS-{Base/Brokered}Notification java type" object into a {@link Document} object.
 * This conversion uses JAXB "unmarshalling" mechanism
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WSNotificationWriter {

	
	private static Logger log = Logger.getLogger(WSNotificationWriter.class.getName());
	
    private WSNotificationJAXBContext notifJaxbContext = null;
        
    /**
     * Default constructor
     * 
     * @throws WSNotificationException
     */
    private WSNotificationWriter(){
		try {
			notifJaxbContext = new WSNotificationJAXBContext();
		} catch (Exception e) {
			log.log(Level.WARNING, "WsNotificationWriter initialisation failed !", e);
		}	
	}
    
    /**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
    private static class WSNotificationWriterHolder {     	
		private final static WSNotificationWriter INSTANCE = new WSNotificationWriter();
	}
    
    /**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationWriter} class.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationWriter getInstance() {
		return WSNotificationWriterHolder.INSTANCE;
	}
	
	/**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationWriter} class.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationWriter getInstance(String[] nsAndPrefixForMarshalling) {
		WSNotificationWriter writer =  WSNotificationWriterHolder.INSTANCE;
		writer.notifJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);		
		return writer;
	}
    
    // ===================== Added by tdejean =============================
    
    /**
     * marchall a {@link Notify} object.
     * 
     * @param notifyObj {@link Notify} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Notify} Java type 
     * @throws WSNotificationException
     */
    public Document writeNotify(Notify notifyObj) throws WSNotificationException{
    	Document result = null;
    	try {
    	
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		// get from corresponding TopicExpression model object, topicNS to add to Document result object.
    		List<List<QName>> topicNSToAdd = new ArrayList<List<QName>>();
    		
    		List<NotificationMessageHolderType> notifMessages = notifyObj.getNotificationMessage(); 
			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
				topicNSToAdd.add(notifMsgItem.getTopic().getTopicNameSpace());
				// remove (temporarily) namespace from java object  
				((TopicExpressionTypeImpl)notifMsgItem.getTopic()).removeTopicNSFromModel();
			}			
    	
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Notify> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Notify>(WsnbConstants.NOTIFY_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.base.Notify.class, (com.ebmwebsourcing.wsstar.notification.definition.base.Notify)
    					((AbstractSchemaElementImpl<?>)notifyObj).getModel());

    		marshaller.marshal(element, result);    		
    		   	
    		// just convert:
            // TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(result);
	    							
			//For each NotificationMessage node, get its Topic Node and "add" topicNS
			List<?> notifMsgNodes = docAsJDom.getRootElement().getChildren(WsnbConstants.NOTIFICATION_MSG_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbConstants.NOTIFICATION_MSG_QNAME.getNamespaceURI()));

			Element currentTopicNode = null;
			for (Object msgNode : notifMsgNodes) {
				currentTopicNode = ((Element)msgNode).getChild(WsnbConstants.TOPIC_QNAME.getLocalPart(),
						Namespace.getNamespace(WsnbConstants.TOPIC_QNAME.getNamespaceURI()));
				List<QName> currentTopicsToAdd = topicNSToAdd.get(notifMsgNodes.indexOf(msgNode));
				for (QName nsItem : currentTopicsToAdd) {
					currentTopicNode.addNamespaceDeclaration(Namespace.getNamespace(nsItem.getLocalPart(), nsItem.getNamespaceURI()));
				}
			}
    		
			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );
   			
   			// --- restore namespaces, previously remove, on java object
   			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
    			for (QName qnItem : topicNSToAdd.get(notifMessages.indexOf(notifMsgItem))) {    		
    				((TopicExpressionTypeImpl)notifMsgItem.getTopic()).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
    			} 
    		}
   			

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (JDOMException exJDom) {
     	   throw new WSNotificationException(
                   "Dom <--> JDom conversion failed !", exJDom);
    	}      

    	return result;
    }
    
    /**
     * marchall a {@link RegisterPublisher} object.
     * 
     * @param regPubObj {@link RegisterPublisher} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link RegisterPublisher} Java type
     * @throws WSNotificationException
     */
    public Document writeRegisterPublisher(RegisterPublisher regPubObj) throws WSNotificationException{
    	Document result = null;
    	try {

    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		List<List<QName>> additianalTopicNSPerExp = new ArrayList<List<QName>>(); 

    		List<TopicExpressionType> topicExprList = regPubObj.getTopic();
    		for (TopicExpressionType topExprItem : topicExprList) {
    			additianalTopicNSPerExp.add(topExprItem.getTopicNameSpace());
    			// remove (temporarily) namespace from java object  
    			((TopicExpressionTypeImpl)topExprItem).removeTopicNSFromModel();
    		}    		 
      		      		
      		// Process Marshalling operation : 
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher>(WsnbrConstants.REGISTER_PUBLISHER_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher) 
    					((AbstractSchemaElementImpl<?>)regPubObj).getModel());

    		marshaller.marshal(element, result);            

    		 // just convert:
            // TODO : replace JDOM and DOM with StaxSource   
   			DOMBuilder builder = new DOMBuilder();
   			org.jdom.Document docAsJDom = builder.build(result);
   			
   			List<?> topicExprNodes = docAsJDom.getRootElement().getChildren(WsnbrConstants.TOPIC_QNAME.getLocalPart(),
   					Namespace.getNamespace(WsnbrConstants.TOPIC_QNAME.getNamespaceURI()));
   			
   			for (Object topExpNodeItem : topicExprNodes) {   				
   				for (QName nsToAddItem : additianalTopicNSPerExp.get(topicExprNodes.indexOf(topExpNodeItem))) {
   					((Element)topExpNodeItem).addNamespaceDeclaration(Namespace.getNamespace(nsToAddItem.getLocalPart(), nsToAddItem.getNamespaceURI()));
   				}
			}
   			//for (List<QName> currentNSList : additianalTopicNSPerExp) {
   				//Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
   				//docAsJDom.getRootElement().addNamespaceDeclaration(topicNS);
   			//}

   			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );    		   			   		 
    	
   			// --- restore namespace on java object
    		for (TopicExpressionType topExprItem : topicExprList) {
    			for (QName qnItem : additianalTopicNSPerExp.get(topicExprList.indexOf(topExprItem))) {    		
    				((TopicExpressionTypeImpl)topExprItem).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
    			} 
    		}
    		   			   		    		
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (JDOMException exJDom) {
     	   throw new WSNotificationException(
                   "Dom <--> JDom conversion failed !", exJDom);
    	}     
    	return result;
    }
    
            
    /**
     * marchall a {@link RegisterPublisherResponse} object.
     * 
     * @param regPubRespObj {@link RegisterPublisherResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link RegisterPublisherResponse} Java type 
     * @throws WSNotificationException
     */
    public Document writeRegisterPublisherResponse(RegisterPublisherResponse regPubRespObj) throws WSNotificationException{
    	Document result = null;
   	 try {
   		 
   		 Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
   		 
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
           
            // TODO : Check if it is a Thread safe method
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse> element = 
                new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse>(WsnbrConstants.REGISTER_PUBLISHER_RESPONSE_QNAME,
               		 com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse) 
               		 ((AbstractSchemaElementImpl<?>)regPubRespObj).getModel());
            
            marshaller.marshal(element, result);            
            
        } catch (final JAXBException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } 
   	    
   	return result;	
    }
    
    /**
     * marchall a {@link PublisherRegistrationRP} object.
     * 
     * @param pubRegRPObj {@link PublisherRegistrationRP} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link PublisherRegistrationRP} Java type
     * @throws WSNotificationException
     */
    public Document writePublisherRegistrationRP(PublisherRegistrationRP pubRegRPObj) throws WSNotificationException{
    	Document result = null;
    	try {

    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		List<List<QName>> additianalTopicNSPerExp = new ArrayList<List<QName>>(); 

    		List<TopicExpressionType> topicExprList = pubRegRPObj.getTopic();
    		for (TopicExpressionType topExprItem : topicExprList) {
    			additianalTopicNSPerExp.add(topExprItem.getTopicNameSpace());
    			// remove (temporarily) namespace from java object  
    			((TopicExpressionTypeImpl)topExprItem).removeTopicNSFromModel();
    		}    		 
      		      		
      		// Process Marshalling operation : 
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP>(WsnbrConstants.PUBLISHER_REGISTRATION_RP_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP) 
    					((AbstractSchemaElementImpl<?>)pubRegRPObj).getModel());

    		marshaller.marshal(element, result);            

    		 // just convert:
            // TODO : replace JDOM and DOM with StaxSource   
   			DOMBuilder builder = new DOMBuilder();
   			org.jdom.Document docAsJDom = builder.build(result);
   			
   			List<?> topicExprNodes = docAsJDom.getRootElement().getChildren(WsnbrConstants.TOPIC_QNAME.getLocalPart(),
   					Namespace.getNamespace(WsnbrConstants.TOPIC_QNAME.getNamespaceURI()));
   			
   			for (Object topExpNodeItem : topicExprNodes) {   				
   				for (QName nsToAddItem : additianalTopicNSPerExp.get(topicExprNodes.indexOf(topExpNodeItem))) {
   					((Element)topExpNodeItem).addNamespaceDeclaration(Namespace.getNamespace(nsToAddItem.getLocalPart(), nsToAddItem.getNamespaceURI()));
   				}
			}
   			//for (List<QName> currentNSList : additianalTopicNSPerExp) {
   				//Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
   				//docAsJDom.getRootElement().addNamespaceDeclaration(topicNS);
   			//}
   			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );    		   			   		 
    	
   			// --- restore namespace on java object
    		for (TopicExpressionType topExprItem : topicExprList) {
    			for (QName qnItem : additianalTopicNSPerExp.get(topicExprList.indexOf(topExprItem))) {    		
    				((TopicExpressionTypeImpl)topExprItem).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
    			} 
    		}
    		   			   		    		
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (JDOMException exJDom) {
     	   throw new WSNotificationException(
                   "Dom <--> JDom conversion failed !", exJDom);
    	}     
    	return result;
    }
    /**
     * marchall a {@link DestroyRegistration} object.
     * 
     * @param destRegObj {@link DestroyRegistration} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link DestroyRegistration} Java type
     * @throws WSNotificationException
     */
    public Document writeDestroyRegistration(DestroyRegistration destRegObj) throws WSNotificationException{
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration>(WsnbrConstants.DESTROY_REGISTRATION_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration)
    					((AbstractSchemaElementImpl<?>)destRegObj).getModel());

    		marshaller.marshal(element, result);            

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} 
    	return result;  
    }
    
    /**
     * marchall a {@link DestroyRegistrationResponse} object.
     * 
     * @param destRegRespObj {@link DestroyRegistrationResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link DestroyRegistrationResponse} Java type 
     * @throws WSNotificationException
     */    
    public Document writeDestroyRegistrationResponse(DestroyRegistrationResponse destRegRespObj) throws WSNotificationException{
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse>(WsnbrConstants.DESTROY_REGISTRATION_RESPONSE_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse)
    					((AbstractSchemaElementImpl<?>)destRegRespObj).getModel());

    		marshaller.marshal(element, result);            

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} 

    	return result;
    }
    
    /**
     * marshall a {@link Subscribe} object
     * 
     * @param subsObj {@link SubscribeResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Subscribe} Java type
     * @throws WSNotificationException
     */
    public Document writeSubscribe(Subscribe subsObj) throws WSNotificationException{
    	Document result = null;
     	 try {

     		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
     		 
     		 List<QName> additianalTopicNS = subsObj.getFilter().getTopicExpression().getTopicNameSpace();
     		 // remove (temporarily) namespace from java object  
     		 ((TopicExpressionTypeImpl)subsObj.getFilter().getTopicExpression()).removeTopicNSFromModel();
     	
     		 
              result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
              // TODO : Check if it is a Thread safe method
              final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe> element = 
                  new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe>(WsnbConstants.SUBSCRIBE_QNAME,
                 		 com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.class,(com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe) 
                 		 ((AbstractSchemaElementImpl<?>)subsObj).getModel());               
              marshaller.marshal(element, result);
                             
           // just convert:
              // TODO : replace JDOM and DOM with StaxSource   
     			DOMBuilder builder = new DOMBuilder();
     			org.jdom.Document docAsJDom = builder.build(result);
     			
     			for (QName currentNS : additianalTopicNS) {
     				Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
     				docAsJDom.getRootElement().getChild(WsnbConstants.FILTER_QNAME.getLocalPart(),
     						Namespace.getNamespace(WsnbConstants.FILTER_QNAME.getNamespaceURI())).getChild(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart(),
     								Namespace.getNamespace(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI())).addNamespaceDeclaration(topicNS);
     			}
     			
     			// just convert:
              // TODO : replace JDOM and DOM with StaxSource
     			DOMOutputter putter = new DOMOutputter ();
     			result = putter.output( docAsJDom );
                    			
     			// --- restore namespace on java object
     			for (QName qnItem : additianalTopicNS) {			
     				((TopicExpressionTypeImpl)subsObj.getFilter().getTopicExpression()).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
     			}	
     			
     			
          } catch (final JAXBException ex) {
              throw new WSNotificationException(
                      "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
          } catch (final ParserConfigurationException ex) {
              throw new WSNotificationException(
                      "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
          }catch (JDOMException exJDom) {
       	   throw new WSNotificationException(
       			   "Dom <--> JDom conversion failed !", exJDom);
          }         	    
     	return result;
    }
    
    /**
     * marshall a {@link SubscribeResponse} object
     * 
     * @param subsRespObj {@link SubscribeResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link SubscribeResponse} Java type 
     * @throws WSNotificationException
     */
    public Document writeSubscribeResponse(SubscribeResponse subsRespObj) throws WSNotificationException{
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
             // TODO : Check if it is a Thread safe method
             final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse>(WsnbConstants.SUBSCRIBE_RESPONSE_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse)
                		 ((AbstractSchemaElementImpl<?>)subsRespObj).getModel());
             marshaller.marshal(element, result);
                         
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }         
    	
    	return result;
    }
    
    /**
     * marshall an {@link Unsubscribe} object
     * 
     * @param unsubsObj {@link Unsubscribe} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Unsubscribe} Java type
     * @throws WSNotificationException
     */
    public Document writeUnsubscribe(Unsubscribe unsubsObj) throws WSNotificationException{
    	Document result = null;
    	 try {
    		 
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		 
    		 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
             // TODO : Check if it is a Thread safe method
             final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe>(WsnbConstants.UNSUBSCRIBE_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe.class,(com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe) 
                		 ((AbstractSchemaElementImpl<?>)unsubsObj).getModel());               
             marshaller.marshal(element, result);                           
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }       	    
    	return result;	
    }
    
    /**
     * marshall an {@link UnsubscribeResponse} object
     * 
     * @param unsubsRespObj {@link UnsubscribeResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link UnsubscribeResponse} Java type
     * @throws WSNotificationException
     */
    public Document writeUnsubscribeResponse(UnsubscribeResponse unsubsRespObj) throws WSNotificationException{
    	Document result = null;
    	
      	 try {
      		 
      		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
               result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
               // TODO : Check if it is a Thread safe method
               final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse> element = 
                   new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse>(WsnbConstants.UNSUBSCRIBE_RESPONSE_QNAME,
                   		com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse)
                   		((AbstractSchemaElementImpl<?>)unsubsRespObj).getModel());
               marshaller.marshal(element, result);
                           
           } catch (final JAXBException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           } catch (final ParserConfigurationException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           }            	
      	return result;	
    }
    
    /**
     * marshall an {@link GetCurrentMessage} object
     * 
     * @param getCurMsgObj {@link GetCurrentMessage} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link GetCurrentMessage} Java type
     * @throws WSNotificationException
     */
    public Document writeGetCurrentMessage(GetCurrentMessage getCurMsgObj) throws WSNotificationException{

    	Document result = null;

    	try {

    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();

    		/*
			 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage> element = 
				new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage>(WsnbConstants.GET_CURRENT_MESSAGE_QNAME,
						com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage.class,(com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage) 
						((AbstractSchemaElementImpl<?>)getCurMsgObj).getModel());               
			marshaller.marshal(element, result);
    		 */

    		// get from corresponding TopicExpression model object, topicNS to add to Document result object.
    		List<QName> topicNSToAdd = getCurMsgObj.getTopic().getTopicNameSpace();
    		// remove (temporarily) namespace from java object  
    		((TopicExpressionTypeImpl)getCurMsgObj.getTopic()).removeTopicNSFromModel();

    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage>(WsnbConstants.GET_CURRENT_MESSAGE_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage.class, (com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessage)
    					((AbstractSchemaElementImpl<?>)getCurMsgObj).getModel());

    		marshaller.marshal(element, result);    		

    		// just convert:
    		// TODO : replace JDOM and DOM with StaxSource   
    		DOMBuilder builder = new DOMBuilder();
    		org.jdom.Document docAsJDom = builder.build(result);

    		//For each NotificationMessage node, get its Topic Node and "add" topicNS

    		Element currentTopicNode = docAsJDom.getRootElement().getChild(WsnbConstants.TOPIC_QNAME.getLocalPart(),
    				Namespace.getNamespace(WsnbConstants.TOPIC_QNAME.getNamespaceURI()));

    		//List<QName> currentTopicsToAdd = topicNSToAdd.get(notifMsgNodes.indexOf(msgNode));
    		for (QName nsItem : topicNSToAdd) {
    			currentTopicNode.addNamespaceDeclaration(Namespace.getNamespace(nsItem.getLocalPart(), nsItem.getNamespaceURI()));
    		}

    		// just convert:
    		// TODO : replace JDOM and DOM with StaxSource
    		DOMOutputter putter = new DOMOutputter ();
    		result = putter.output( docAsJDom );

    		// --- restore namespaces, previously remove, on java object
    		for (QName qnItem : topicNSToAdd) {    		
    			((TopicExpressionTypeImpl)getCurMsgObj.getTopic()).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
    		} 

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (JDOMException exJDom) {
    		throw new WSNotificationException(
    				"Dom <--> JDom conversion failed !", exJDom);
    	}         	         	   
    	return result;	
    }

    /**
     * marshall an {@link GetCurrentMessageResponse} object
     * 
     * @param getCurMsgRespObj {@link GetCurrentMessageResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link GetCurrentMessageResponse} Java type
     * @throws WSNotificationException
     */
    public Document writeGetCurrentMessageResponse(GetCurrentMessageResponse getCurMsgRespObj) throws WSNotificationException{
    	Document result = null;
    	 try {
    		 
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		 
    		 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
             // TODO : Check if it is a Thread safe method
             final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse>(WsnbConstants.GET_CURRENT_MESSAGE_RESPONSE_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.base.GetCurrentMessageResponse) 
                		 ((AbstractSchemaElementImpl<?>)getCurMsgRespObj).getModel());               
             marshaller.marshal(element, result);                           
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }       	    
    	return result;	
    }
    
    /**
     * marshall an {@link Renew} object
     * 
     * @param renewObj {@link Renew} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Renew} Java type
     * @throws WSNotificationException
     */
    public Document writeRenew(Renew renewObj) throws WSNotificationException{
    	Document result = null;
    	 try {
    		 
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		 
    		 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
             // TODO : Check if it is a Thread safe method
             final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Renew> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Renew>(WsnbConstants.RENEW_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.Renew.class,(com.ebmwebsourcing.wsstar.notification.definition.base.Renew) 
                		 ((AbstractSchemaElementImpl<?>)renewObj).getModel());               
             marshaller.marshal(element, result);                           
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }       	    
    	return result;	
    }
    
    /**
     * marshall an {@link RenewResponse} object
     * 
     * @param renewRespObj {@link RenewResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link RenewResponse} Java type
     * @throws WSNotificationException
     */
    public Document writeRenewResponse(RenewResponse renewRespObj) throws WSNotificationException{
    	Document result = null;
    	
      	 try {
      		 
      		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
               result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
               // TODO : Check if it is a Thread safe method
               final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.RenewResponse> element = 
                   new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.RenewResponse>(WsnbConstants.RENEW_RESPONSE_QNAME,
                   		com.ebmwebsourcing.wsstar.notification.definition.base.RenewResponse.class,(com.ebmwebsourcing.wsstar.notification.definition.base.RenewResponse)
                   		((AbstractSchemaElementImpl<?>)renewRespObj).getModel());
               marshaller.marshal(element, result);
                           
           } catch (final JAXBException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           } catch (final ParserConfigurationException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           }            	
      	return result;	
    }
   
    /**
     * marshall a {@link SubscriptionManagerRP} into a file (used to persist the java object) 
     * 
     * @param subscription the {@link SubscriptionManagerRP} java object to persist
     * @param file {@link File} object used to persist {@link SubscriptionManagerRP} Object
     * @throws WSNotificationException
     */
    public void writeSubscriptionToFile(SubscriptionManagerRP subscription, File file) throws WSNotificationException{
    	 try {
    		 Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		 
    		 final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP> element = 
                 new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP>(WsnbConstants.SUBSCRIPTION_MGR_RP_QNAME,
                		 com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP.class,(com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP)
                		 ((AbstractSchemaElementImpl<?>)subscription).getModel());
    		 marshaller.marshal(element, file);
             
         } catch (final JAXBException ex) {
             throw new WSNotificationException(
                     "Failed to marshall " + SubscriptionManagerRP.class.getSimpleName()
                    + " Object from SchemaImpl descriptor Java classes, to file : \n\t" +
                    file.getAbsolutePath() + "\n", ex);
         }         
    }
    

   /** marshall a {@link SubscriptionManagerRP} object
    * 
    * @param subsRPObj {@link SubscriptionManagerRP} Java object to marshall
    * @return {@link org.w3c.dom.Document} representation of the {@link SubscriptionManager} Java type
    * @throws WSNotificationException
    */
   public Document writeSubscriptionManagerRP(SubscriptionManagerRP subsRPObj) throws WSNotificationException{
	   Document result = null;
   	 try {

   		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
   		 
   		 List<QName> additianalTopicNS = subsRPObj.getFilter().getTopicExpression().getTopicNameSpace();
   		 // remove (temporarily) namespace from java object  
   		 ((TopicExpressionTypeImpl)subsRPObj.getFilter().getTopicExpression()).removeTopicNSFromModel();
   	
   		 
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
            // TODO : Check if it is a Thread safe method
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP> element = 
                new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP>(WsnbConstants.SUBSCRIPTION_MGR_RP_QNAME,
               		 com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP.class,(com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP) 
               		 ((AbstractSchemaElementImpl<?>)subsRPObj).getModel());               
            marshaller.marshal(element, result);
                           
         // just convert:
            // TODO : replace JDOM and DOM with StaxSource   
   			DOMBuilder builder = new DOMBuilder();
   			org.jdom.Document docAsJDom = builder.build(result);
   			
   			for (QName currentNS : additianalTopicNS) {
   				Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
   				docAsJDom.getRootElement().getChild(WsnbConstants.FILTER_QNAME.getLocalPart(),
   						Namespace.getNamespace(WsnbConstants.FILTER_QNAME.getNamespaceURI())).getChild(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart(),
   								Namespace.getNamespace(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI())).addNamespaceDeclaration(topicNS);
   			}
   			
   			// just convert:
            // TODO : replace JDOM and DOM with StaxSource
   			DOMOutputter putter = new DOMOutputter ();
   			result = putter.output( docAsJDom );
                  			
   			// --- restore namespace on java object
   			for (QName qnItem : additianalTopicNS) {			
   				((TopicExpressionTypeImpl)subsRPObj.getFilter().getTopicExpression()).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
   			}	
   			
   			
        } catch (final JAXBException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSNotificationException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        }catch (JDOMException exJDom) {
     	   throw new WSNotificationException(
     			   "Dom <--> JDom conversion failed !", exJDom);
        }         	    
   	return result;
   }
    
    
    /**
     * marshall a {@link TopicExpressionType} object
     * 
     * @param topicExpression {@link TopicExpressionType} Java object to marshall
     * @return {@linkorg.w3c.dom.Document} representation of the {@link TopicExpressionType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicExpressionType(TopicExpressionType topicExpression) throws WSNotificationException{
    	Document result = null;    
    	
     	 try {
       
     		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
     		 
     		 List<QName> additianalTopicNS = topicExpression.getTopicNameSpace();
     		 // remove (temporarily) namespace from java object  
     		 ((TopicExpressionTypeImpl)topicExpression).removeTopicNSFromModel();
     		 
     		 result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();                              
              // TODO : Check if it is a Thread safe method
              final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> element = 
                  new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType>(WsnbConstants.TOPIC_EXPRESSION_QNAME,
                  		com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType.class,(com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType)
                  		((AbstractSchemaElementImpl<?>)topicExpression).getModel());
              marshaller.marshal(element, result);

           // just convert:
           // TODO : replace JDOM and DOM with StaxSource   
  			DOMBuilder builder = new DOMBuilder();
  			org.jdom.Document docAsJDom = builder.build(result);
  			
  			for (QName currentNS : additianalTopicNS) {
  				Namespace topicNS = Namespace.getNamespace(currentNS.getLocalPart(),currentNS.getNamespaceURI());
  				docAsJDom.getRootElement().addNamespaceDeclaration(topicNS);
  			}

  			// just convert:
           // TODO : replace JDOM and DOM with StaxSource
  			DOMOutputter putter = new DOMOutputter ();
  			result = putter.output( docAsJDom );
  			
  			// --- restore namespace on java object
  			for (QName qnItem : additianalTopicNS) {			
 				((TopicExpressionTypeImpl)topicExpression).addTopicNameSpace(qnItem.getLocalPart(), qnItem.getNamespaceURI());
 			}	
  			        
          } catch (final JAXBException ex) {
              throw new WSNotificationException(
                      "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
          } catch (final ParserConfigurationException ex) {
              throw new WSNotificationException(
                      "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
          } catch (JDOMException exJDom) {
       	   throw new WSNotificationException(
       			   "Dom <--> JDom conversion failed !", exJDom);
          }            	          
          return result;		
    }
	
    /**
     * marshall a {@link QueryExpressionType} object
     * 
     * @param topicExpression {@link QueryExpressionType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link QueryExpressionType} Java type
     * @throws WSNotificationException
     */
    public Document writeQueryExpressionType(QueryExpressionType queryExpression) throws WSNotificationException{
    	Document result = null;    

    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();                              
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType>(WsnbConstants.MESSAGE_CONTENT_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType.class,(com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType)
    					((AbstractSchemaElementImpl<?>)queryExpression).getModel());
    		marshaller.marshal(element, result);

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	}          	          
    	return result;
    }
    
    /**
     * marshall a {@link Message} object
     * 
     * @param topicExpression {@link Message} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Message} Java type
     * @throws WSNotificationException
     */
    public Document writeMessageType(Message message) throws WSNotificationException{
    	Document result = null;    

    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();                              
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message>(WsnbConstants.MESSAGE_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message.class,
    					(com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message)
    					((AbstractSchemaElementImpl<?>)message).getModel());
    		marshaller.marshal(element, result);

    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	}          	          
    	return result;
    }
	    
    /**
     * marshall a {@link TopicType} object
     * 
     * @param topic {@link TopicType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicType(TopicType topic) throws WSNotificationException{
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType>(WstopConstants.TOPIC_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType.class,(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType) 
    					((AbstractSchemaElementImpl<?>)topic).getModel());               
    		marshaller.marshal(element, result);                           
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	} catch (final ParserConfigurationException ex) {
    		throw new WSNotificationException(
    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
    	}       	    
    	return result;
    }
	
    /**
     * marshall a {@link TopicNamespaceType} object
     * 
     * @param namespace {@link TopicNamespaceType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicNamespaceType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicNamespaceType(TopicNamespaceType namespace) throws WSNotificationException{
    	Document result = null;
    	try {
    		
    		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
    		
    		result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
    		// TODO : Check if it is a Thread safe method
    		final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType> element = 
    			new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType>(WstopConstants.TOPICNAMESPACE_QNAME,
    					com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.class,(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType) 
    					((AbstractSchemaElementImpl<?>)namespace).getModel());               
    		marshaller.marshal(element, result);                           
    	} catch (final JAXBException ex) {
    		throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         } catch (final ParserConfigurationException ex) {
             throw new WSNotificationException(
                     "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
         }       	    
    	return result;
    }
    
    /**
     * marshall a {@link TopicSetType} object
     * 
     * @param namespace {@link TopicSetType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicSetType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicSetType(TopicSetType topicSet) throws WSNotificationException{
    	Document result = null;
      	 try {
      		 
      		Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
      		
               result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();           
               // TODO : Check if it is a Thread safe method
               final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType> element = 
                   new JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType>(WstopConstants.TOPICSET_QNAME,
                  		 com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType.class,(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType) 
                  		 ((AbstractSchemaElementImpl<?>)topicSet).getModel());               
               marshaller.marshal(element, result);                           
           } catch (final JAXBException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           } catch (final ParserConfigurationException ex) {
               throw new WSNotificationException(
                       "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
           }       	    
      	return result;
    }
	
    /**
     * method used to persist {@link SubscriptionManagerRP} java object to a file
     * 
     * @param subscriptionRP the {@link SubscriptionManagerRP} java Object to persist
     * @param persist the {@link File} which the object must be persisted in
     * @throws WSNotificationException
     */
    public void writeSubscriptionManagerRP(SubscriptionManagerRP subscriptionRP,File persist) throws WSNotificationException{
    	Document subsRPAsDom = this.writeSubscriptionManagerRP(subscriptionRP);
		this.flushToFile(subsRPAsDom, persist);		
    }
   
    /**
     * method used to persist {@link SubscribeResponse} java object to a file
     * 
     * @param subscriptionRP the {@link SubscribeResponse} java Object to persist
     * @param persist the {@link File} which the object must be persisted in
     * @throws WSNotificationException
     */
    public void writeSubscribeResponse(SubscribeResponse subscribeResp,File persist) throws WSNotificationException{
    	Document subsRespAsDom = this.writeSubscribeResponse(subscribeResp);
		this.flushToFile(subsRespAsDom, persist);		
    }
    /**
     * method used to persist {@link PublisherRegistrationRP} java object to a file
     * 
     * @param subscriptionRP the {@link PublisherRegistrationRP} java Object to persist
     * @param persist the {@link File} which the object must be persisted in
     * @throws WSNotificationException
     */
    public void writePublisherRegistrationRP(PublisherRegistrationRP registrationRP, File persist) throws WSNotificationException{
    	Document regRPAsDom = this.writePublisherRegistrationRP(registrationRP);
		this.flushToFile(regRPAsDom, persist);		
    }
    
    /**
     * write a DOM document to a file
     * @param doc the DOM document to write on the file system
     * @param file the file which the DOM document must be write in
     * @throws WSNotificationException
     */
    private void flushToFile(Document doc, File file) throws WSNotificationException {

		try{
			// Prepare the DOM document for writing		    
			Source source = new DOMSource(doc);

			// Prepare the output file		    		
			Result result = new StreamResult(file);

			// Write the DOM document to the file
			Transformer xformer;

			xformer = TransformerFactory.newInstance().newTransformer();
			xformer.transform(source, result);
			
		} catch (TransformerConfigurationException e) {
			throw new WSNotificationException("Problem occurs during \"persistency\" process",e);
		} catch (TransformerFactoryConfigurationError e) {
			throw new WSNotificationException("Problem occurs during \"persistency\" process",e);
		} catch (TransformerException e) {			
			throw new WSNotificationException("Problem occurs during \"persistency\" process",e);
		}
	    
	} 
}