package com.ebmwebsourcing.wsstar.notification.extension.impl;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;

public class TerminationTimeTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType>
		implements TerminationTimeType {
	
	private static final long serialVersionUID = 1L;

	public TerminationTimeTypeImpl(com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType#getValue()
	 */
	public Date getValue() {				
		XMLGregorianCalendar xmlCalendar = this.model.getValue();
		return xmlCalendar.toGregorianCalendar().getTime();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType#setValue(java.util.Date)
	 */
	public void setValue(Date value) throws WSNotificationExtensionException {
				
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
		} catch (DatatypeConfigurationException e) {
			throw new WSNotificationExtensionException(e);
		}
		this.model.setValue(xmlCalendar);
		
	}

}
