/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.api;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.SchemaElement;
/**
 * This interface provides an encapsulated version of the JAXB Class
 * {@ link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType}.
 * It also uses EASYWSDL library encapsulation model. 
 * 
 * @author Thierry Déjean -eBM WebSourcing
 */
public interface SOAParameterType extends SchemaElement {

	public static final String CDK_ADDRESS = "http://petals.ow2.org/cdk";
	
	public static final String DEFAULT_PETALS_ADDRESS= CDK_ADDRESS; //"http://petals.ow2.org/ws-addressing/default";
		
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType} JAXB*
	 * generated class
	 */
	public String getEndpoint();
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType} JAXB*
	 * generated class
	 */
	public void setEndpoint(String value);
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType} JAXB*
	 * generated class
	 */
	public QName getInterface();
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType} JAXB*
	 * generated class
	 */
	public void setInterface(QName value);
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType} JAXB*
	 * generated class
	 */
	public QName getService();
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType} JAXB*
	 * generated class
	 */
	public void setService(QName value);
	
}
