/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.impl;

import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;


import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnExtensionConstants;
/**
 * This class implements {@link ResourcesUuidTypeImpl} java interface respect to
 * EASYWSDL Library model.
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class ResourcesUuidTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ResourcesUuidType> implements
		ResourcesUuidType {
		
	private static final long serialVersionUID = 1L;

	private QName tagName = new QName(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE, WsnExtensionConstants.RESOURCES_UUID_ROOT_TAG);
	
	/**
 	 * Constructor (follow EASYWSDL model)
 	 *
	 * @param model
	 * @param parent
	 */
	public ResourcesUuidTypeImpl(
			com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ResourcesUuidType model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType#addUuid(java.lang.String)
	 */
	public void addUuid(String uuid) {
		this.model.getUuid().add(uuid);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType#clearUuids()
	 */
	public void clearUuids() {
		this.model.getUuid().clear();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType#getUuids()
	 */
	public List<String> getUuids() {
		return this.model.getUuid();
	}

	/**
	 *  tagName attribut getter
	 * @return the QName tagName attribut value
	 */
	public QName getTagName() {
		return tagName;
	}
	
	/**
	 * tagName attribut setter
	 * 
	 * @param tagName the QName to set
	 */
	public void setTagName(QName tagName) {
		this.tagName = tagName;
	}
	
}
