/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.impl;

import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
/**
 * This class implements {@link SOAParameterType} java interface respect to
 * EASYWSDL Library model.
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class SOAParameterTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.SOAParameterType>
	implements SOAParameterType{

	private static final long serialVersionUID = 1L;
	
	/**
 	 * Constructor (follow EASYWSDL model)
 	 *
	 * @param model
	 * @param parent
	 */
	public SOAParameterTypeImpl(
			com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.SOAParameterType model,
			AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType#getEndpoint()
	 */
	public String getEndpoint() {
		return this.model.getEndpoint();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType#getInterface()
	 */
	public QName getInterface() {
		return this.model.getInterfaceName();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType#getService()
	 */
	public QName getService() {
		return this.model.getServiceName();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType#setEndpoint(java.lang.String)
	 */
	public void setEndpoint(String value) {
		this.model.setEndpoint(value);		
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType#setInterface(javax.xml.namespace.QName)
	 */
	public void setInterface(QName value) {
		this.model.setInterfaceName(value);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType#setService(javax.xml.namespace.QName)
	 */
	public void setService(QName value) {
		this.model.setServiceName(value);
	}
			
}
