/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.fault;

import javax.xml.bind.JAXBElement;

import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.ResumeFailedFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class ResumeFailedFault extends WSNotificationFault {

	private static final long serialVersionUID = 1L;

	public ResumeFailedFault(String lang, String descr) throws WSNotificationException {
		super();
		this.wsnFault = WSNotificationFactory.getInstance().createResumeFailedFaultType();
		this.init(lang, descr);
	}
	
	@Override
	protected JAXBElement<?> createJAXBElem() throws WSNotificationException {
		JAXBElement<?> jaxbFaultRep =
			WSNotificationFactory.getInstance().createResumeFailedFault((ResumeFailedFaultType)wsnFault);
		return jaxbFaultRep;
	}

}
