/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.fault;

import java.util.GregorianCalendar;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.definition.basefaults.api.BaseFaultType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationJAXBContext;

/**
 * 
 * @author tdejean - eBM WebSourcing
 */
public abstract class WSNotificationFault extends Throwable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	protected BaseFaultType wsnFault;
	
	public WSNotificationFault() {	
	}
	
	public WSNotificationFault(BaseFaultType fault) {
		this.wsnFault = fault;
	}
	
	protected void init(String lang, String descContent) throws WSNotificationException {
		
		//BaseFaultType.Description descr = WSNotificationFactory.getInstance().createBaseFaultTypeDescription();
		wsnFault.setDescriptionLanguage(lang);
		wsnFault.setDescriptionValue(descContent);			
		GregorianCalendar gCalendar = new GregorianCalendar();			
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			wsnFault.setTimestamp(xmlCalendar);				
		} catch (DatatypeConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
	
	public void setWsnFault(BaseFaultType wsnFault) {
		this.wsnFault = wsnFault;
	}
	
	public BaseFaultType getWsnFault() {
		return wsnFault;
	}
	
	public Document getDocumentFragment() {
		Document result = null;
		try {
			result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();		
			//WSNotificationWriterImpl.getMarshaller().marshal(createJAXBElem(), result);
			/*
			((WSNotificationWriterImpl)WSNotificationFactory
					.getInstance().newWSNotificationWriter()).getMarshaller().marshal(createJAXBElem(), result);				
			 */
			Marshaller marshellar = ((new WSNotificationJAXBContext()).getJaxbContext()).createMarshaller();
			marshellar.marshal(createJAXBElem(), result);
						
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (WSNotificationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SchemaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;		
	}
	
	protected abstract JAXBElement<?> createJAXBElem() throws WSNotificationException;
	
}
