/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.persistance;

import com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnPersistance {
    private File path;

    public WsnPersistance(File path) {
        if (path == null) {
            throw new NullPointerException("Persistance folder must not be null");
        }
        if (!path.exists()) {
            path.mkdirs();
        }
        this.path = path;
    }

    public void persist(SubscriptionManagerRP subscription) throws Exception {
        File persist = this.getSubscriptionPersistanceFileName(subscription);
        if (persist == null) {
            throw new Exception("The persistance file can not be created");
        }
        if (!persist.exists()) {
            persist.createNewFile();
        }
    }

    public boolean delete(SubscriptionManagerRP subscription) throws Exception {
        boolean result = true;
        return result;
    }

    public boolean delete(String topicName) {
        File topicPath;
        File subsPath = this.getSubscriptionPath(topicName);
        if (subsPath.exists() && subsPath.isDirectory()) {
            File[] files;
            for (File file : files = subsPath.listFiles()) {
                file.delete();
            }
        }
        if ((topicPath = this.getTopicPath(topicName)).exists() && topicPath.isDirectory()) {
            File[] files;
            for (File file : files = topicPath.listFiles()) {
                file.delete();
            }
        }
        return topicPath.delete();
    }

    public List<SOAPEnvelope> getSubscriptionEnvelopesForTopic(QName topicName) {
        ArrayList<SOAPEnvelope> result = new ArrayList<SOAPEnvelope>();
        return result;
    }

    public void cleanSubscriptions(QName topicName) {
    }

    private SOAPEnvelope loadEnvelope(File f) {
        SOAPEnvelope envelope = null;
        try {
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(StAXUtils.createXMLStreamReader((InputStream)new FileInputStream(f)), null);
            envelope = (SOAPEnvelope)builder.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        return envelope;
    }

    private File getTopicPath(String topicName) {
        return new File(this.path, topicName);
    }

    private File getSubscriptionPath(String topicName) {
        return new File(this.getTopicPath(topicName), "subscriptions");
    }

    private File getSubscriptionPersistanceFileName(SubscriptionManagerRP subscription) {
        File result = null;
        return result;
    }
}

