/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.brokerednotification;


import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;

/**
 * 
 * @author tdejean - eBM WebSourcing
 *
 */
public interface WsnbrPublisherRegistrationManager {
	
	/**
	 * destroy an existing Publisher registration (Topics, ...)
	 * 
	 * @param request
	 * @return a DestroyRegistrationResponse object as describe in WS-BrokeredNotification spec (p.25)
	 * @throws WSNotificationException
	 * @throws WSNotificationFault 
	 * @throws WSNotificationExtensionException 
	 */
	public DestroyRegistrationResponse destroyRegistration(DestroyRegistration request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException;
	
}
