/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.PauseSubscription;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.PauseSubscriptionResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.ResumeSubscription;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.ResumeSubscriptionResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbPausableSubscriptionManager;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationNotImplementedException;

public class PausableSubscriptionManagerMgr extends SubscriptionManagerMgr
		implements WsnbPausableSubscriptionManager {

	public PausableSubscriptionManagerMgr(Logger logger, WstopTopicManager topicMgr) {
		super(logger, topicMgr);
	}
		
	public PauseSubscriptionResponse pauseSubscription(PauseSubscription request)
			throws WSNotificationException, WSNotificationFault {
		logger.log(Level.FINE, "performs a \"PauseSubscription\" request ...");
		//TODO : implement this method !!!
		throw new WSNotificationNotImplementedException(this.getClass().getName(),"PauseSubscription");
	}

	public ResumeSubscriptionResponse resumeSubscription(
			ResumeSubscription request) throws WSNotificationException,
			WSNotificationFault {
		logger.log(Level.FINE, "performs a \"ResumeSubscription\" request ...");
		//TODO : implement this method !!!
		throw new WSNotificationNotImplementedException(this.getClass().getName(),"ResumeSubscription");
	}

}
