/**
 * easySchema - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.wsstar.qml.impl;

import java.io.StringWriter;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.qml.api.Constraint;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLWriter;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 * @author Le Duc Bao - France Telecom
 */
public class WSQMLWriterImpl extends WSQMLJAXBContext implements
	WSQMLWriter {

    /**
     * The JAXB unique marshaller.
     */
    private static Marshaller marshaller = null;

    /**
     * The exception raised during JAXB unique marshaller creation.
     */
    private static WSQMLException marshallerCreationEx = null;

    /*
     * Private object initializations
     */
    static {
        try {
            WSQMLJAXBContext.createContext();
            WSQMLWriterImpl.marshaller = WSQMLJAXBContext.getJaxbContext().createMarshaller();
            // marshaller.setSchema(parent);

        } catch (final JAXBException e) {
            final WSQMLException schemaCreationEx = new WSQMLException(
                    "Failed to create context", e);

            WSQMLWriterImpl.marshallerCreationEx = new WSQMLException(
                    "Failed to create the JAXB marshaller", schemaCreationEx);

        } catch (final SchemaException e) {
            final WSQMLException schemaCreationEx = new WSQMLException(
                    "Failed to create context", e);

            WSQMLWriterImpl.marshallerCreationEx = new WSQMLException(
                    "Failed to create the JAXB marshaller", schemaCreationEx);

        }
    }

    @SuppressWarnings("unchecked")
    private static Document convertQoSDimension2DOMElement(final QName tagName,
            final com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension def)
            throws WSQMLException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            // TODO : Check if it is a Thread safe method
            final JAXBElement element = new JAXBElement(tagName, def.getClass(), def);

            WSQMLWriterImpl.marshaller.marshal(element, doc);
        } catch (final JAXBException ex) {
            throw new WSQMLException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSQMLException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);

        }
        return doc;
    }

    @SuppressWarnings("unchecked")
    private static String convertQoSDimension2String(
            final com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension def)
            throws WSQMLException {

        try {
            final StringWriter stringWriter = new StringWriter();
            // TODO : Check if it is a Thread safe method

            final JAXBElement element = new JAXBElement(new QName(Constants.WSQML_NAMESPACE,
            		Constants.QOS_DIMENSION_ROOT_TAG), def.getClass(), def);

            WSQMLWriterImpl.marshaller.marshal(element, stringWriter);

            return stringWriter.toString();
        } catch (final JAXBException e) {
            throw new WSQMLException(
                    "Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    /**
     * Get the marshaller instance.
     *
     * @return the marshaller instance
     * @throws SchemaException
     *             The exception raised during the marshaller creation.
     */
    public static Marshaller getMarshaller() throws WSQMLException {

        if (WSQMLWriterImpl.marshallerCreationEx != null) {
            throw WSQMLWriterImpl.marshallerCreationEx;
        }

        return WSQMLWriterImpl.marshaller;
    }

    public Document getDocument(final QOSDimension def) throws WSQMLException {
        Document doc = null;
        if ((def != null)
                && (def instanceof QOSDimension)) {
                doc = WSQMLWriterImpl
                        .convertQoSDimension2DOMElement(def.getTagQName(), (com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension) ((AbstractSchemaElementImpl) def)
                                .getModel());
                if(def.getDocumentBaseURI() != null) {
                	doc.setDocumentURI(def.getDocumentBaseURI().getPath());
                }
        }
        return doc;
    }

    public boolean getFeature(final String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public String writeQOSDimension(final QOSDimension def) throws WSQMLException {
        String res = null;
        if ((def != null)
                && (def instanceof QOSDimension)) {
                res = WSQMLWriterImpl
                        .convertQoSDimension2String((com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension) ((AbstractSchemaElementImpl) def)
                                .getModel());
            
        }
        return res;
    }

    
    @SuppressWarnings("unchecked")
    private static Document convertConstraint2DOMElement(final QName tagName,
            final com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType def)
            throws WSQMLException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            // TODO : Check if it is a Thread safe method
            final JAXBElement element = new JAXBElement(tagName, def.getClass(), def);

            WSQMLWriterImpl.marshaller.marshal(element, doc);
        } catch (final JAXBException ex) {
            throw new WSQMLException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSQMLException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);

        }
        return doc;
    }

    @SuppressWarnings("unchecked")
    private static String convertConstraint2String(
            final com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType def)
            throws WSQMLException {

        try {
            final StringWriter stringWriter = new StringWriter();
            // TODO : Check if it is a Thread safe method

            final JAXBElement element = new JAXBElement(new QName(Constants.WSQML_NAMESPACE,
            		Constants.CONSTRAINT_ROOT_TAG), def.getClass(), def);

            WSQMLWriterImpl.marshaller.marshal(element, stringWriter);

            return stringWriter.toString();
        } catch (final JAXBException e) {
            throw new WSQMLException(
                    "Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    
    public Document getDocument(final Constraint def) throws WSQMLException {
        Document doc = null;
        if ((def != null)
                && (def instanceof Constraint)) {
                doc = WSQMLWriterImpl
                        .convertConstraint2DOMElement(def.getTagQName(), (com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType) ((AbstractSchemaElementImpl) def)
                                .getModel());
                if(def.getDocumentBaseURI() != null) {
                	doc.setDocumentURI(def.getDocumentBaseURI().getPath());
                }
        }
        return doc;
    }
    
    public String writeConstraint(final Constraint def) throws WSQMLException {
        String res = null;
        if ((def != null)
                && (def instanceof Constraint)) {
                res = WSQMLWriterImpl
                        .convertConstraint2String((com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType) ((AbstractSchemaElementImpl) def)
                                .getModel());
            
        }
        return res;
    }

}
