package com.ebmwebsourcing.wsstar.qml.api;

import java.net.URI;

import javax.xml.namespace.QName;

/**
 * @author <a href="mailto:leducbao@gmail.com">Le Duc Bao - France Telecom</a>
 * @version 1.0
 */

public interface EquivalentTo {

	/**
	 * Set the document base URI of this definition. Can be used to represent
	 * the origin of the Definition, and can be exploited when resolving
	 * relative URIs (e.g. in &lt;import&gt;s).
	 * 
	 * @param documentBaseURI
	 *            the document base URI of this definition
	 */
	public void setDocumentBaseURI(URI documentBaseURI);

	/**
	 * Get the document base URI of this definition.
	 * 
	 * @return the document base URI
	 */
	public URI getDocumentBaseURI();

	QName getTagQName();

	void setTagQName(QName name);

	public String getName();

	public void setName(String name);

	public Conversion getConversion();

	public void setConversion(Conversion conversion);
}
