package com.ebmwebsourcing.wsstar.qml.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.Constraint;
import com.ebmwebsourcing.wsstar.qml.api.Value;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLReader.FeatureConstants;

/**
 * @author <a href="mailto:leducbao@gmail.com">Le Duc Bao - France Telecom</a>
 * @version 1.0
 */

public class ConstraintImpl
		extends
		AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType>
		implements Constraint {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ConstraintImpl.class.getName());

	/**
	 * the baseUri
	 */
	protected URI baseURI;

	private QName tagName = new QName(Constants.WSQML_NAMESPACE,
			Constants.CONSTRAINT_ROOT_TAG);

	private Value val;

	/**
	 * Features
	 */
	protected Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

	public ConstraintImpl(final URI baseURI,
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType model,
			final Map<FeatureConstants, Object> features) throws WSQMLException {
		super(model, null);
		this.baseURI = baseURI;
		this.features = features;

		if (this.model.getValue() != null) {
			this.val = new ValueImpl(this.model.getValue(), this);
		}
	}

	public ConstraintImpl(
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType model,
			final AbstractSchemaElementImpl parent) throws WSQMLException {
		super(model, parent);

		if (this.model.getValue() != null) {
			this.val = new ValueImpl(this.model.getValue(), this);
		}
	}

	public QName getTagQName() {
		return this.tagName;
	}

	public void setTagQName(QName name) {
		this.tagName = name;
	}

	/**
	 * methods for baseURI
	 */
	public URI getDocumentBaseURI() {
		URI res = null;
		try {
			if ((this.baseURI != null) && (this.baseURI.getPath() != null)
					&& (this.baseURI.getPath().lastIndexOf("/") != -1)) {
				res = new URI(this.baseURI.getPath().substring(0,
						this.baseURI.getPath().lastIndexOf("/") + 1));
			} else {
				res = this.baseURI;
			}
		} catch (final URISyntaxException e) {
			log.warning("BaseURI is null : " + this.baseURI);
		}
		return res;
	}

	public void setDocumentBaseURI(final URI documentBaseURI) {
		this.baseURI = documentBaseURI;
	}

	public String getOperator() {
		return this.model.getOperator();
	}

	public Value getValue() {
		return this.val;
	}

	public void setOperator(String op) {
		this.model.setOperator(op);
	}

	public void setValue(Value val) {
		this.model
				.setValue((com.ebmwebsourcing.wsstar.qml.upmc.fr.Value) ((AbstractSchemaElementImpl) val)
						.getModel());
		this.val = val;
	}

	public Value newValue() throws WSQMLException {
		return new ValueImpl(new com.ebmwebsourcing.wsstar.qml.upmc.fr.Value(),
				this);
	}

}
