package com.ebmwebsourcing.wsstar.qml.impl;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.Conversion;
import com.ebmwebsourcing.wsstar.qml.api.Expr;
import com.ebmwebsourcing.wsstar.qml.api.Unit;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;

/**
 * @author <a href="mailto:leducbao@gmail.com">Le Duc Bao - France Telecom</a>
 * @version 1.0
 */

public class ConversionImpl
		extends
		AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.Conversion>
		implements Conversion {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ConversionImpl.class.getName());

	private Unit fromUnit = null;
	private Unit toUnit = null;
	private Expr expr = null;

	public ConversionImpl(
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.Conversion model,
			final AbstractSchemaElementImpl parent) throws WSQMLException {
		super(model, parent);

		if (this.model.getFromUnit() != null
				&& this.model.getFromUnit().getUnit() != null) {
			this.fromUnit = new UnitImpl(this.model.getFromUnit().getUnit(),
					this);
		}

		if (this.model.getToUnit() != null
				&& this.model.getToUnit().getUnit() != null) {
			this.toUnit = new UnitImpl(this.model.getToUnit().getUnit(), this);
		}

		if (this.model.getExpr() != null) {
			this.expr = new ExprImpl(this.model.getExpr(), this);
		}

	}

	public Expr getExpr() {
		return this.expr;
	}

	public Unit getFromUnit() {
		return this.fromUnit;
	}

	public Unit getToUnit() {
		return this.toUnit;
	}

	public void setExpr(Expr unit) {
		// TODO Auto-generated method stub
	}

	public void setFromUnit(Unit unit) {
		// TODO Auto-generated method stub
	}

	public void setToUnit(Unit unit) {
		// TODO Auto-generated method stub
	}
}
