package com.ebmwebsourcing.wsstar.qml.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.Conversion;
import com.ebmwebsourcing.wsstar.qml.api.EquivalentTo;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLReader.FeatureConstants;

/**
 * @author <a href="mailto:leducbao@gmail.com">Le Duc Bao - France Telecom</a>
 * @version 1.0
 */

public class EquivalentToImpl
		extends
		AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.EquivalentTo>
		implements EquivalentTo {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(EquivalentToImpl.class.getName());

	protected URI baseURI;

	private QName tagName = new QName(Constants.WSQML_NAMESPACE,
			Constants.EQUIVALENT_TO_ROOT_TAG);

	protected Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

	private Conversion conversion = null;

	public EquivalentToImpl(final URI baseURI,
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.EquivalentTo model,
			final Map<FeatureConstants, Object> features) throws WSQMLException {
		super(model, null);
		this.baseURI = baseURI;
		this.features = features;

		if (this.model.getConversion() != null) {
			this.conversion = new ConversionImpl(this.model.getConversion(),
					this);
		}
	}

	public EquivalentToImpl(
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.EquivalentTo model,
			final AbstractSchemaElementImpl parent) throws WSQMLException {
		super(model, parent);

		if (this.model.getConversion() != null) {
			this.conversion = new ConversionImpl(this.model.getConversion(),
					this);
		}
	}

	public QName getTagQName() {
		return this.tagName;
	}

	public void setTagQName(QName name) {
		this.tagName = name;
	}

	/**
	 * methods for baseURI
	 */
	public URI getDocumentBaseURI() {
		URI res = null;
		try {
			if ((this.baseURI != null) && (this.baseURI.getPath() != null)
					&& (this.baseURI.getPath().lastIndexOf("/") != -1)) {
				res = new URI(this.baseURI.getPath().substring(0,
						this.baseURI.getPath().lastIndexOf("/") + 1));
			} else {
				res = this.baseURI;
			}
		} catch (final URISyntaxException e) {
			log.warning("BaseURI is null : " + this.baseURI);
		}
		return res;
	}

	public void setDocumentBaseURI(final URI documentBaseURI) {
		this.baseURI = documentBaseURI;
	}

	public Conversion getConversion() {
		return this.conversion;
	}

	public String getName() {
		return this.model.getName();
	}

	public void setConversion(Conversion conversion) {
		// TODO Auto-generated method stub
	}

	public void setName(String name) {
		// TODO Auto-generated method stub

	}

}
