package com.ebmwebsourcing.wsstar.qml.impl;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.Expr;
import com.ebmwebsourcing.wsstar.qml.api.ExprBinary;
import com.ebmwebsourcing.wsstar.qml.api.ExprUnary;
import com.ebmwebsourcing.wsstar.qml.api.Input;
import com.ebmwebsourcing.wsstar.qml.api.Value;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;

/**
 * @author <a href="mailto:leducbao@gmail.com">Le Duc Bao - France Telecom</a>
 * @version 1.0
 */

public class ExprImpl extends
		AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.Expr>
		implements Expr {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ExprImpl.class.getName());

	private ExprBinary binary = null;
	private ExprUnary unary = null;
	private Value value = null;
	private Input input = null;

	public ExprImpl(final com.ebmwebsourcing.wsstar.qml.upmc.fr.Expr model,
			final AbstractSchemaElementImpl parent) throws WSQMLException {
		super(model, parent);

		if (this.model.getExprBinary() != null) {
			this.binary = new ExprBinaryImpl(this.model.getExprBinary(), this);
		}

		if (this.model.getExprUnary() != null) {
			this.unary = new ExprUnaryImpl(this.model.getExprUnary(), this);
		}

		if (this.model.getValue() != null) {
			this.value = new ValueImpl(this.model.getValue(), this);
		}

		if (this.model.getInput() != null) {
			this.input = new InputImpl(this.model.getInput(), this);
		}

	}

	public Input getInput() {
		return input;
	}

	public Value getValue() {
		return value;
	}

	public ExprBinary getExprBinary() {
		return this.binary;
	}

	public ExprUnary getExprUnary() {
		return this.unary;
	}

	public void setExprBinary(ExprBinary value) {
		// TODO Auto-generated method stub

	}

	public void setExprUnary(ExprUnary value) {
		// TODO Auto-generated method stub

	}

	public void setValue(Value value) {
		// TODO Auto-generated method stub

	}

	public void setInput(String value) {
		// TODO Auto-generated method stub

	}

}
