package com.ebmwebsourcing.wsstar.qml.impl;

import java.util.List;
import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.Expr;
import com.ebmwebsourcing.wsstar.qml.api.ExprBinary;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;

/**
 * @author <a href="mailto:leducbao@gmail.com">Le Duc Bao - France Telecom</a>
 * @version 1.0
 */

public class ExprBinaryImpl
		extends
		AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.ExprBinary>
		implements ExprBinary {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ExprBinaryImpl.class.getName());

	private Expr firstOperand = null;
	private Expr secondOperand = null;

	public ExprBinaryImpl(
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.ExprBinary model,
			final AbstractSchemaElementImpl parent) throws WSQMLException {
		super(model, parent);
		if (this.model.getContent() != null
				&& this.model.getContent().size() >= 2) {
			List<com.ebmwebsourcing.wsstar.qml.upmc.fr.Expr> content = this.model
					.getContent();
			firstOperand = new ExprImpl(content.get(0), this);
			secondOperand = new ExprImpl(content.get(1), this);
		}
	}

	public String getBinary() {
		return this.model.getBinary();
	}

	public Expr getFirstOperand() {
		return this.firstOperand;
	}

	public Expr getSecondOperand() {
		return this.secondOperand;
	}

	public void setBinary(String value) {
		// TODO Auto-generated method stub

	}
}
