/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.qml;

import com.ebmwebsourcing.wsstar.qml.api.Constraint;
import com.ebmwebsourcing.wsstar.qml.api.EquivalentTo;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLReader;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLWriter;
import com.ebmwebsourcing.wsstar.qml.impl.ConstraintImpl;
import com.ebmwebsourcing.wsstar.qml.impl.EquivalentToImpl;
import com.ebmwebsourcing.wsstar.qml.impl.QOSDimensionImpl;
import com.ebmwebsourcing.wsstar.qml.impl.WSQMLReaderImpl;
import com.ebmwebsourcing.wsstar.qml.impl.WSQMLWriterImpl;

/**
 * This class is a concrete implementation of the abstract class WSDMFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSQMLFactoryImpl extends WSQMLFactory {


    /**
     * Create a new instance of a WSDLReaderImpl.
     * @throws WSDMException 
     */
    @Override
    public WSQMLReader newWSQMLReader() throws WSQMLException {
        final WSQMLReader reader = new WSQMLReaderImpl();
        return reader;
    }

    /**
     * Create a new instance of a WSDLWriterImpl.
     * @throws WSDMException 
     */
    @Override
    public WSQMLWriter newWSQMLWriter() throws WSQMLException {
        final WSQMLWriter writer = new WSQMLWriterImpl();
        return writer;
    }
    
    @Override
    public QOSDimension newQOSDimension() throws WSQMLException {
        return new QOSDimensionImpl(new com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension(), null);
    }

	@Override
	public Constraint newConstraint() throws WSQMLException {
		return new ConstraintImpl(new com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType(), null);
	}

	@Override
	public EquivalentTo newEquivalentTo() throws WSQMLException {
		return new EquivalentToImpl(new com.ebmwebsourcing.wsstar.qml.upmc.fr.EquivalentTo(), null);
	}



}
