package com.ebmwebsourcing.wsstar.qml.impl;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.Type;
import com.ebmwebsourcing.wsstar.qml.api.Unit;
import com.ebmwebsourcing.wsstar.qml.api.Value;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;

public class ValueImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.Value> implements Value {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(ValueImpl.class.getName());

	
	private Type type;
	
	private Unit unit;

	public ValueImpl(
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.Value model,
			final AbstractSchemaElementImpl parent)
	throws WSQMLException {
		super(model, parent);
		
		if(this.model.getType() != null) {
			this.type = new TypeImpl(this.model.getType(), this);
		}
		
		if(this.model.getUnit() != null) {
			this.unit = new UnitImpl(this.model.getUnit(), this);
		}
	}



	public Type getType() {
		return this.type;
	}



	public Unit getUnit() {
		return this.unit;
	}



	public Float getValue() {
		return this.model.getFloatValue();
	}



	public void setType(Type t) {
		this.model.setType((com.ebmwebsourcing.wsstar.qml.upmc.fr.Type) ((AbstractSchemaElementImpl)t).getModel());
		this.type = t;
	}



	public void setUnit(Unit unit) {
		this.model.setUnit((com.ebmwebsourcing.wsstar.qml.upmc.fr.Unit) ((AbstractSchemaElementImpl)unit).getModel());
		this.unit = unit;
	}



	public void setValue(Float val) {
		this.model.setFloatValue(val);
	}



	public Type newType() throws WSQMLException {
		return new TypeImpl(new com.ebmwebsourcing.wsstar.qml.upmc.fr.Type(), this);
	}



	public Unit newUnit() throws WSQMLException {
		return new UnitImpl(new com.ebmwebsourcing.wsstar.qml.upmc.fr.Unit(), this);
	}







}
