package com.ebmwebsourcing.wsstar.qml.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLReader.FeatureConstants;

public class QOSDimensionImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension> implements QOSDimension {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(QOSDimensionImpl.class.getName());

	
    /**
     * the baseUri
     */
    protected URI baseURI;
    
    private QName tagName = new QName(Constants.WSQML_NAMESPACE, Constants.QOS_DIMENSION_ROOT_TAG);
    
    
    /**
     * Features
     */
    protected Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

	public QOSDimensionImpl(final URI baseURI,
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension model,
			final Map<FeatureConstants, Object> features)
	throws WSQMLException {
		super(model, null);
		this.baseURI = baseURI;
		this.features = features;
	}
	
	public QOSDimensionImpl(
			final com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension model,
			final AbstractSchemaElementImpl parent)
	throws WSQMLException {
		super(model, parent);
	
	}
	
	public QName getTagQName() {
		return this.tagName;
	}

	public void setTagQName(QName name) {
		this.tagName = name;
	}

	   /**
     * methods for baseURI
     */
    public URI getDocumentBaseURI() {
        URI res = null;
        try {
            if ((this.baseURI != null)&&(this.baseURI.getPath() != null)&&(this.baseURI.getPath().lastIndexOf("/") != -1)) {
                res = new URI(this.baseURI.getPath().substring(0,
                        this.baseURI.getPath().lastIndexOf("/") + 1));
            } else {
            	res = this.baseURI;
            }
        } catch (final URISyntaxException e) {
            log.warning("BaseURI is null : " + this.baseURI);
        }
        return res;
    }

    public void setDocumentBaseURI(final URI documentBaseURI) {
        this.baseURI = documentBaseURI;
    }

	public String getOntology() {
		return this.model.getOntology();
	}

	public String getSemanticConcept() {
		return this.model.getSemanticConcept();
	}

	public void setOntology(String ontology) {
		this.model.setOntology(ontology);
	}

	public void setSemanticConcept(String semConcept) {
		this.model.setSemanticConcept(semConcept);
	}



}
