/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.resource.definition.basefaults.impl;

import javax.xml.datatype.XMLGregorianCalendar; 

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.resource.definition.basefaults.api.BaseFaultDescriptionType;
import com.ebmwebsourcing.wsstar.resource.definition.basefaults.api.BaseFaultType;
import com.ebmwebsourcing.wsstar.resource.definition.utils.WSResourceException;
import com.ebmwebsourcing.wsstar.resource.definition.utils.WSResourceJAXBContext;

/**
 * This class implements {@link BaseFaultType {@code} . As it uses EASYWSDL model, it also extends the abstract class {@link AbstractSchemaElementImpl {@code} . See EASYWSDL Library documentation for more details.
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class BaseFaultTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.resource.basefaults.BaseFaultType> implements BaseFaultType {

	private static final long serialVersionUID = 1L;

	private BaseFaultDescriptionType description = null;

	public BaseFaultTypeImpl(final com.ebmwebsourcing.wsstar.jaxb.resource.basefaults.BaseFaultType model, final AbstractSchemaElementImpl<?> parent) throws WSResourceException {
		super(model, parent);
	}

	public String getDescriptionValue() {
		final String result = "";
		if (this.description != null) {
			this.description.getValue();
		}
		return result;
	}

	public String getDescriptionLanguage() {
		String result = "";
		if (this.description != null) {
			result = this.description.getLang();
		}
		return result;
	}

	public void setDescriptionValue(final String content) throws WSResourceException {
		if (this.description == null) {
			this.description = 
				new BaseFaultDescriptionTypeImpl(WSResourceJAXBContext.wsrfbfFactory.createBaseFaultTypeDescription(),null);
		}
		this.description.setValue(content);
	}

	public void setDescriptionLanguage(final String lang) throws WSResourceException {
		if (this.description == null) {
			this.description = 
				new BaseFaultDescriptionTypeImpl(WSResourceJAXBContext.wsrfbfFactory.createBaseFaultTypeDescription(),null);
		}
		this.description.setLang(lang);
	}

	public XMLGregorianCalendar getTimestamp() {
		return this.model.getTimestamp();
	}

	public void setTimestamp(final XMLGregorianCalendar value) {
		this.model.setTimestamp(value);
	}

}