package com.ebmwebsourcing.wsstar.resource.definition.resourcelifetime.impl;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.resource.definition.resourcelifetime.api.TerminationNotification;
import com.ebmwebsourcing.wsstar.resource.definition.utils.WSResourceException;

public class TerminationNotificationImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.resource.resourcelifetime.TerminationNotification>
		implements TerminationNotification {

	private static final long serialVersionUID = 1L;

	public TerminationNotificationImpl(com.ebmwebsourcing.wsstar.jaxb.resource.resourcelifetime.TerminationNotification model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	@Override
	public Element getTerminationReason() {
		
		Object objFromModel = this.model.getTerminationReason();
		return (objFromModel instanceof Element)? (Element)objFromModel : null;
	}

	@Override
	public Date getTerminationTime() {
		Date result = null;
		final XMLGregorianCalendar valueFromModel = this.model.getTerminationTime();
		if (valueFromModel != null) {
			result = valueFromModel.toGregorianCalendar().getTime();
		}
		return result;
	}

	@Override
	public void setTerminationReason(Element reason) {
		this.model.setTerminationReason(reason);
	}

	@Override
	public void setTerminationTime(Date value) throws WSResourceException {
		
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setTerminationTime(xmlCalendar);			
		} catch (final DatatypeConfigurationException e) {
			throw new WSResourceException(e);
		}
	}

}
