package com.ebmwebsourcing.wsstar.resource.definition.resourcelifetime.impl;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.resource.definition.resourcelifetime.api.TerminationTime;
import com.ebmwebsourcing.wsstar.resource.definition.utils.WSResourceException;

public class TerminationTimeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.resource.resourcelifetime.TerminationTime> implements
		TerminationTime {

	private static final long serialVersionUID = 1L;

	public TerminationTimeImpl(com.ebmwebsourcing.wsstar.jaxb.resource.resourcelifetime.TerminationTime model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	@Override
	public Date getValue() {

		Date result = null;
		final XMLGregorianCalendar valueFromModel = this.model.getValue();
		if (valueFromModel != null) {
			result = valueFromModel.toGregorianCalendar().getTime();
		}
		return result;
	}

	@Override
	public void setValue(Date value) throws WSResourceException {
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setValue(xmlCalendar);			
		} catch (final DatatypeConfigurationException e) {
			throw new WSResourceException(e);
		}

	}

}
