/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api;

import javax.xml.namespace.QName;

/**
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WsaConstants {
	
	protected WsaConstants(){
		// prevents calls from subclass
        throw new UnsupportedOperationException();
	};
	
	/**
     * WS-ADDRESSING "normative" namespace
     */
    public static final String WSADDRESSING_NAMESPACE = "http://www.w3.org/2005/08/addressing";
  
    /**
     * WS-ADDRESSING commonly used prefix
     */
    public static final String WSADDRESSING_PREFIX = "wsa";
    
    /**
     * WS-ADDRESSING XML schema QNames
     */
    public static final QName ENDPOINT_REFERENCE_QNAME = new QName(WSADDRESSING_NAMESPACE,"EndpointReference",WSADDRESSING_PREFIX);

    public static final QName ADDRESS_QNAME = new QName(WSADDRESSING_NAMESPACE, "Address", WSADDRESSING_PREFIX);

    public static final QName SERVICE_NAME_QNAME = new QName(WSADDRESSING_NAMESPACE, "ServiceName",	WSADDRESSING_PREFIX);
  
    /**
     * WS-ADDRESSING Abstract properties definitions QName
     */  
    public static final QName TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "To", WSADDRESSING_PREFIX);

    public static final QName FROM_QNAME = new QName(WSADDRESSING_NAMESPACE, "From", WSADDRESSING_PREFIX);

    public static final QName REPLY_TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "ReplyTo", WSADDRESSING_PREFIX);

    public static final QName FAULT_TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "FaultTo", WSADDRESSING_PREFIX);

    public static final QName ACTION_QNAME = new QName(WSADDRESSING_NAMESPACE, "Action", WSADDRESSING_PREFIX);

    public static final QName MESSAGE_ID_QNAME = new QName(WSADDRESSING_NAMESPACE, "MessageID", WSADDRESSING_PREFIX);
    
    public static final QName RELATES_TO = new QName(WSADDRESSING_NAMESPACE, "RelatesTo", WSADDRESSING_PREFIX);
    
    public static final QName REFERENCE_PARAMETERS = new QName(WSADDRESSING_NAMESPACE, "ReferenceParameters", WSADDRESSING_PREFIX);
    
    /**
     * WS-ADDRESSING predefined QName "FaultCodes types (according to ws-addr.xsd xml schema)
     */    
    public static final QName INVALID_ADDRESSING_HEADER = 
    	new QName(WSADDRESSING_NAMESPACE, "InvalidAddressingHeader", WSADDRESSING_PREFIX);
    public static final QName INVALID_ADDRESS = 
    	new QName(WSADDRESSING_NAMESPACE, "InvalidAddress", WSADDRESSING_PREFIX);
    public static final QName INVALID_EPR = 
    	new QName(WSADDRESSING_NAMESPACE, "InvalidEPR", WSADDRESSING_PREFIX);
    public static final QName INVALID_CARDINALITY = 
    	new QName(WSADDRESSING_NAMESPACE, "InvalidCardinality", WSADDRESSING_PREFIX);
    public static final QName MISSING_ADDRESS_IN_EPR = 
    	new QName(WSADDRESSING_NAMESPACE, "MissingAddressInEPR", WSADDRESSING_PREFIX);
    public static final QName DUPLICATED_MESSAGE_ID = 
    	new QName(WSADDRESSING_NAMESPACE, "DuplicateMessageID", WSADDRESSING_PREFIX);
    public static final QName ACTION_MISMATCH = 
    	new QName(WSADDRESSING_NAMESPACE, "ActionMismatch", WSADDRESSING_PREFIX);
    public static final QName MESSAGE_ADDRESSING_HEADER_REQUIRED = 
    	new QName(WSADDRESSING_NAMESPACE, "MessageAddressingHeaderRequired", WSADDRESSING_PREFIX);
    public static final QName DESTINATION_UNREACHABLE = 
    	new QName(WSADDRESSING_NAMESPACE, "DestinationUnreachable", WSADDRESSING_PREFIX);
    public static final QName ACTION_NOT_SUPPORTED = 
    	new QName(WSADDRESSING_NAMESPACE, "ActionNotSupported", WSADDRESSING_PREFIX);
    public static final QName ENDPOINT_UNAVAILABLE = 
    	new QName(WSADDRESSING_NAMESPACE, "EndpointUnavailable", WSADDRESSING_PREFIX);
    
}
