/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction;

import java.util.List;

import org.w3c.dom.Element;

/**
 * Interface related to "ReferenceParametersType" WS-Addressing type
 * Thought to be the most "user-friendly" as possible according to
 * WS-Addressing specification content and especially its associated
 * XML Schema 
 * 
 * @author Thierry Déjean - EBM Websourcing
 */
public interface ReferenceParametersType {

	/**
	 * Get the reference parameters content values
	 * 
	 * @return the list of reference parameters as a list of {@link Element} object
	 */
	List<Element> getAny();
	
	/**
	 * add a reference parameters to the endpoint reference parameters part
	 * 
	 * @param anyAsElt the reference parameters to add, provided as {@link Element} object
	 */
	void addAny(Element anyAsElt);

	/**
	 * add a list of reference parameters to the endpoint reference parameters part 
	 * 
	 * @param anyAsElts the list of reference parameters to add, provided as a list of {@link Element} object 
	 */
	void addAllAny(List<Element> anyAsElts);
}
