/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction;

import java.net.URI;

/**
 * Interface of the factory that must provide creation methods
 * of WS-Addressing Types. Mainly expected methods are those
 * which help to build {@link EndpointReferenceType}, 
 * {@link ReferenceParametersType} and {@link MetadataType} typed objects.
 * Also provide getters for {@link WsaReader} and {WsaWriter} objects.
 * 
 * NOTE : the factory is implemented following the "Bridge" design pattern
 * and the "WsaFactory" class represents the "abstraction" part    
 * 
 * @author Thierry Déjean - EBM Websourcing
 *
 */
public interface WsaFactory {
	
	/**
	 * create a minimal {@link EndpointReferenceType} object with only
	 * mandatory fields set
	 *  
	 * @param address of the endpoint to create, as a {@link URI} object   
	 * 
	 * @return an {@link EndpointReferenceType} object with address set
	 */
	EndpointReferenceType createEndpointReferenceType(URI address) ;
	
	/**
	 * create a minimal - means empty - {@link EndpointReferenceType} object
	 *  
	 * @return an empty {@link ReferenceParametersType} object
	 */
	ReferenceParametersType createReferenceParametersType();
	
	/**
	 * create a minimal - means empty - {@link MetadataType} object
	 * 
	 * @return an empty {@link MetadataType} object
	 */
	MetadataType createMetadataType();
		
	/**
	 * Get a instance of {@link WsaReader} class 
	 * 
	 * @return an instance of of {@link WsaReader} class
	 */
	WsaReader getWsaReader();
	
	/**
	 * Get a instance of {@link WsaWriter} class 
	 * 
	 * @return an instance of of {@link WsaWriter} class
	 */
	WsaWriter getWsaWriter();	
	
}
