/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.refinedabstraction;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.MetadataType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaReader;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaWriter;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.implementor.WsaModelFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import java.net.URI;

public final class RefinedWsaFactory
implements WsaFactory {
    private WsaModelFactory model;

    private RefinedWsaFactory() {
    }

    public static WsaFactory getInstance() throws WsaException {
        RefinedWsaFactory singleton = WsaFactoryHolder.INSTANCE;
        if (singleton.model == null) {
            throw new WsaException("\n\t/!\\ WARNING /!\\\nThe WsaModelFactory have not been initialized !!!\nPlease create a \"WsaModelFactory\" instance and \ncall the \"getInstance(WsaModelFactory)\" method instead.\n\t/!\\ WARNING /!\\\n");
        }
        return singleton;
    }

    public static WsaFactory getInstance(WsaModelFactory modelFactory) {
        RefinedWsaFactory singleton = WsaFactoryHolder.INSTANCE;
        singleton.model = modelFactory;
        return singleton;
    }

    public WsaModelFactory getModel() {
        return this.model;
    }

    protected void setModel(WsaModelFactory modelFactory) {
        this.model = modelFactory;
    }

    @Override
    public EndpointReferenceType createEndpointReferenceType(URI address) {
        return this.model.createWsaModelEndpointReferenceType(address);
    }

    @Override
    public ReferenceParametersType createReferenceParametersType() {
        return this.model.createWsaModelReferenceParametersType();
    }

    @Override
    public MetadataType createMetadataType() {
        return this.model.createWsaModelMetadataType();
    }

    @Override
    public WsaReader getWsaReader() {
        return this.model.getWsaModelReader();
    }

    @Override
    public WsaWriter getWsaWriter() {
        return this.model.getWsaModelWriter();
    }

    private static final class WsaFactoryHolder {
        private static final RefinedWsaFactory INSTANCE = new RefinedWsaFactory();

        private WsaFactoryHolder() {
        }
    }
}

