/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.MetadataType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.WsaJAXBContext;
import com.ebmwebsourcing.wsstar.jaxb.addressing.AttributedURIType;

public class EndpointReferenceTypeImpl implements EndpointReferenceType {

	private com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbTypeObj;
	private static Logger logger = Logger.getLogger(EndpointReferenceTypeImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "address" field is mandatory
	 * 
	 * @param address the address of the {@link EndpointReferenceType} object that must
	 * 		  be {@link String} representation of an {@link URI} object.
	 */
	protected EndpointReferenceTypeImpl(URI address) {
		this.jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createEndpointReferenceType();
		this.jaxbTypeObj.setAddress(EndpointReferenceTypeImpl.toAttributedURIType(address));		
	}
	
	protected EndpointReferenceTypeImpl(com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbTypeObj) {
		this.jaxbTypeObj = jaxbTypeObj;
	}	
	
	/**
	 * Getter on associated Jaxb's model object
	 * 
	 * @return the associated Jaxb's model object
	 */
	public final com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType getJaxbTypeObj() {
		return jaxbTypeObj;
	}	
	
	@Override
	public final URI getAddress() {
		// ~~ Note : Not be null according to related xml schema
		URI result = null;
		String uriAsString = this.jaxbTypeObj.getAddress().getValue();
		try {
			result = new URI(uriAsString);
		} catch (URISyntaxException e) {
			/*throw new WsaException(*/
			EndpointReferenceTypeImpl.logger.log(Level.WARNING,"The \"Address\" field " +
					"value of the \"EndpointReference\" does not respect the URI Syntax (according to" +
					" RFC-2396/RFC-2732).\nUri string value is :\n\t " + uriAsString + "\n" /*,e*/);			
		}
		return result;
	}

	@Override
	public final void setAddress(URI value) {
		this.jaxbTypeObj.setAddress(EndpointReferenceTypeImpl.toAttributedURIType(value));
	}

	@Override
	public final ReferenceParametersType getReferenceParameters() {		
		
		com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType jaxbRefParams = this.jaxbTypeObj.getReferenceParameters();
		
		return ((jaxbRefParams != null )? new ReferenceParametersTypeImpl(jaxbRefParams.getAny()): null); 
	}

	@Override
	public final void setReferenceParameters(ReferenceParametersType value) {

		com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType jaxbRefParams = this.jaxbTypeObj.getReferenceParameters();

		if (jaxbRefParams == null){
			jaxbRefParams = WsaJAXBContext.WSA_FACTORY.createReferenceParametersType();
			this.jaxbTypeObj.setReferenceParameters(jaxbRefParams);
		} else {
			jaxbRefParams.getAny().clear();
		}
		jaxbRefParams.getAny().addAll(value.getAny());			
	}

	@Override
	public final MetadataType getMetadata() {
		com.ebmwebsourcing.wsstar.jaxb.addressing.MetadataType jaxbMetadata = this.jaxbTypeObj.getMetadata();
		return ((jaxbMetadata != null )? new MetadataTypeImpl(jaxbMetadata.getAny()): null); 
	}

	@Override
	public final void setMetadata(MetadataType value) {
		com.ebmwebsourcing.wsstar.jaxb.addressing.MetadataType jaxbMetadata = this.jaxbTypeObj.getMetadata();

		if (jaxbMetadata == null){
			jaxbMetadata = WsaJAXBContext.WSA_FACTORY.createMetadataType();
			this.jaxbTypeObj.setMetadata(jaxbMetadata);
		} else {
			jaxbMetadata.getAny().clear();
		}
		jaxbMetadata.getAny().addAll(value.getAny());
	}
	
	@Override
	public final List<Element> getAny() {
		List<Element> wsExtensions = new ArrayList<Element>();
		List<Object> anyFromJaxbModel = this.jaxbTypeObj.getAny();
		for (Object extItem : anyFromJaxbModel) {
			if (extItem instanceof Element){
				wsExtensions.add((Element) extItem);
			}
		}			
		return wsExtensions;
	}
	
	@Override
	public final void addAny(Element anyAsElt) {
		this.jaxbTypeObj.getAny().add(anyAsElt);
	}
	
	@Override
	public final void addAllAny(List<Element> anyAsElts) {
		this.jaxbTypeObj.getAny().addAll(anyAsElts);
	}
	
	/**
	 * Private method use to hide then {@link AttributedURIType} type
	 * and also to avoid to duplicate piece of code
	 *    
	 * @param address the content of the "address" field - as {@link String} - 
	 * 			of the {@link AttributedURIType} object 
	 */
	private static AttributedURIType toAttributedURIType(URI address){
		AttributedURIType uri = WsaJAXBContext.WSA_FACTORY.createAttributedURIType();
		uri.setValue(address.toString());
		return uri;
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType}
	 *  "Jaxb model type" object from a {@link EndpointReferenceType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType toJaxbModel(EndpointReferenceType apiTypeObj){

		com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbTypeObj = null;

		if (apiTypeObj instanceof EndpointReferenceTypeImpl) {
			jaxbTypeObj = ((EndpointReferenceTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createEndpointReferenceType();	

			jaxbTypeObj.setAddress(EndpointReferenceTypeImpl.toAttributedURIType(apiTypeObj.getAddress()));

			ReferenceParametersType refParams = apiTypeObj.getReferenceParameters();
			if (refParams != null){
				jaxbTypeObj.setReferenceParameters(ReferenceParametersTypeImpl.toJaxbModel(refParams));
			}

			MetadataType metadata = apiTypeObj.getMetadata();
			if (metadata != null){
				jaxbTypeObj.setMetadata(MetadataTypeImpl.toJaxbModel(metadata));
			}

			List<Element> any = apiTypeObj.getAny();
			if (any != null){
				jaxbTypeObj.getAny().addAll(any);
			}
		}
		return jaxbTypeObj;
	}
	
}
