/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.WsaJAXBContext;

public class ReferenceParametersTypeImpl implements ReferenceParametersType{

	private com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType jaxbTypeObj;
	
	protected ReferenceParametersTypeImpl() {
		this.jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createReferenceParametersType();
	}
	
	protected ReferenceParametersTypeImpl(com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType jaxbTypeObj) {		
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected ReferenceParametersTypeImpl(List<Object> any) {
		this.jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createReferenceParametersType();
		this.jaxbTypeObj.getAny().addAll(any);		
	}
	
	/**
	 *  Getter on associated Jaxb's model object
	 *  
	 * @return the associated Jaxb's model object
	 */
	public final com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType getJaxbTypeObj() {
		return jaxbTypeObj;
	}

	@Override
	public final List<Element> getAny() {		
		List<Element> anyList = new ArrayList<Element>();
		List<Object> anyFromJaxbModel = this.jaxbTypeObj.getAny();
		for (Object extItem : anyFromJaxbModel) {
			if (extItem instanceof Element){
				anyList.add((Element) extItem);
			}
		}			
		return anyList;
	}
	
	@Override
	public final void addAny(Element anyAsElt) {
		this.jaxbTypeObj.getAny().add(anyAsElt);
	}
	
	@Override
	public final void addAllAny(List<Element> anyAsElts) {
		this.jaxbTypeObj.getAny().addAll(anyAsElts);
	}
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType}
	 *  "Jaxb model type" object from a {@link ReferenceParametersType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType toJaxbModel(ReferenceParametersType apiTypeObj){

		com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType jaxbTypeObj = null;
		
		if (apiTypeObj instanceof ReferenceParametersTypeImpl) {
			jaxbTypeObj = ((ReferenceParametersTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createReferenceParametersType();	

			List<Element> refParamsObjs = apiTypeObj.getAny();		
			if (refParamsObjs != null){
				jaxbTypeObj.getAny().addAll(refParamsObjs);
			}	
		}
		return jaxbTypeObj;
	}

}
