/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import java.net.URI;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.MetadataType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaReader;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaWriter;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.implementor.WsaModelFactory;

public class WsaModelFactoryImpl implements WsaModelFactory {
	
	private WsaReaderImpl wsaModelReader;
	private WsaWriterImpl wsaModelWriter;
	
	public WsaModelFactoryImpl() {
		this.wsaModelReader = new WsaReaderImpl();
		this.wsaModelWriter = new WsaWriterImpl();		
	}
	
	@Override
	public final WsaReader getWsaModelReader() {
		return wsaModelReader;
	}
	
	@Override
	public final WsaWriter getWsaModelWriter() {
		return wsaModelWriter;
	}
	
	@Override
	public final EndpointReferenceType createWsaModelEndpointReferenceType(URI address) {
		return new EndpointReferenceTypeImpl(address);
	}
	
	public final EndpointReferenceType createWsaModelEndpointReferenceType(
			com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbModelObj) {
		return new EndpointReferenceTypeImpl(jaxbModelObj);
	}

	@Override
	public final ReferenceParametersType createWsaModelReferenceParametersType() {
		return new ReferenceParametersTypeImpl();
	}
	
	public final ReferenceParametersType createWsaModelReferenceParametersType(
			com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType jaxbModelObj) {
		return new ReferenceParametersTypeImpl(jaxbModelObj);
	}

	@Override
	public final MetadataType createWsaModelMetadataType() {
		return new MetadataTypeImpl();
	}
	
	public final MetadataType createWsaModelMetadataType(
			com.ebmwebsourcing.wsstar.jaxb.addressing.MetadataType jaxbModelObj) {
		return new MetadataTypeImpl(jaxbModelObj);
	}

}
