/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
//import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaReader;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.WsaJAXBContext;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonException;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonUtils;

/**
 * This class provides a collection of methods that enable conversion of a
 * {@link Document} object into a "WS-Addressing java type" object.
 * This conversion uses JAXB "unmarshalling" mechanism
 * 
 * @author Thierry DEJEAN - eBM WebSourcing
 */
public class WsaReaderImpl implements WsaReader{

	//private final Logger logger = Logger.getLogger(WsaReaderImpl.class.getName());

	private WsaJAXBContext addressingJaxbContext = null;
	
	/**
	 * Default constructor
	 */
	protected WsaReaderImpl() {
//		try {
			this.addressingJaxbContext = WsaJAXBContext.getInstance();
//		} catch (Exception e) {
//			this.log.log(Level.WARNING, "WS-Addressing Reader initialisation failed !", e);
//		}
	}
	
	protected WsaReaderImpl(String[] nsAndPrefixForMarshalling) {
//		try {			
			this.addressingJaxbContext = WsaJAXBContext.getInstance(nsAndPrefixForMarshalling);
			//this.addressingJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);	
//		} catch (Exception e) {
//			this.log.log(Level.WARNING, "WSAddressing Reader initialisation failed !", e);
//		}
	}
		
//	/**
//	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
//	 * or the first access to SingletonHolder.INSTANCE, not before.
//	 */
//    private static class WSResourceReaderHolder {     	
//		private final static WsaReaderImpl INSTANCE = new WsaReaderImpl();
//	}
//    
//    /**
//	 * Return an unique - respect to the Singleton design pattern - instance  
//	 * of the {@link WsaReaderImpl} class.  
//	 * 
//	 * @return a unique WSResourceReader instance. 
//	 */
//	public static WsaReaderImpl getInstance() {
//		return WSResourceReaderHolder.INSTANCE;
//	}
//	
//
//	/**
//	 * Return an unique - respect to the Singleton design pattern - instance  
//	 * of the {@link WsaReaderImpl} class.  
//	 * 
//	 * @param nsAndPrefixForMarshalling customize namespace/prefix to used
//	 * @return a unique WSAddressingReader instance. 
//	 */
//	public static WsaReaderImpl getInstance(String[] nsAndPrefixForMarshalling) {
//		WsaReaderImpl reader =  WSResourceReaderHolder.INSTANCE;
//		reader.addressingJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);		
//		return reader;
//	}
	
	/**
	 *  Read the specified EndpointReferenceType XML definition from {@link Document} object 
	 *  into a WS-Addressing JAXB model {@link EndpointReferenceType} instance.
     * 
	 * @param doc
	 * @return  the definition described in the document.
     *
	 * @throws WsaException
	 */
	@Override
	public final EndpointReferenceType readEndpointReferenceType(Document doc) throws WsaException {
		EndpointReferenceType edpRefObj=null;  
				
		try {
			Unmarshaller unmarshaller = this.addressingJaxbContext.createWSAddressingUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> eprBinding = 
				unmarshaller.unmarshal(doc, com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType.class);
			
			edpRefObj = ((eprBinding!=null)? new EndpointReferenceTypeImpl(eprBinding.getValue()):null);
				
		} catch (JAXBException e) {
			throw new WsaException(e);
		}

		return edpRefObj;
	}
	
	
	/**
     * Read a EndpointReferenceType XML definition from an {@link InputSource} object
     * into a WS-Addressing JAXB model {@link EndpointReferenceType} instance.
     * 
     * @param inputSource
     *            an InputSource pointing to the SchemaImpl document, an XML
     *            document obeying the SchemaImpl parent.
     * @return the definition described in the document pointed to by the
     *         InputSource.
     *         
	 * @throws WsaException
     */
	@Override
	public final EndpointReferenceType readEndpointReferenceType(InputSource inputSource) throws WsaException{
		EndpointReferenceType edpRefObj=null;
		try {
			final Unmarshaller unmarshaller = this.addressingJaxbContext.createWSAddressingUnmarshaller();

			//final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			//final EasyXMLFilter filter = new org.ow2.easywsdl.schema.util.EasyXMLFilter(xmlReader);
			final SAXSource saxSource = new SAXSource(/*filter*/inputSource);

			// TODO use SAX validation instead of JAXB validation
			// turn off the JAXB provider's default validation mechanism to
			// avoid duplicate validation
			// SchemaReaderImpl.getUnMarshaller().setValidating( false );

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> eprBinding = unmarshaller.unmarshal(
					saxSource, com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType.class);

			edpRefObj = ((eprBinding!=null)? new EndpointReferenceTypeImpl(eprBinding.getValue()):null);
			
		} catch (final JAXBException e) {
			throw new WsaException(e);
		} /*catch (final SAXException e) {
			throw new WSAddressingModelException(e);
		}*/
		return edpRefObj;
	}
	/**
     * Read the SchemaImpl document accessible via the specified URI into a
     * SchemaImpl definition.
     * 
     * @param schemaURI
     *            a URI (can be a filename or URL) pointing to a SchemaImpl XML
     *            definition.
     * @return the definition.
     * 
	 * @throws WsaException
     */
	@Override
    public final EndpointReferenceType readEndpointReferenceType(URI uri) throws WsaException{
    	EndpointReferenceType desc = null;
		
    	try {
			InputStream input = null;
			final File f = new File(uri.getPath());
			if (f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = uri.toURL().openStream();
			}
			desc = this.readEndpointReferenceType(new InputSource(input));
			
		} catch (final MalformedURLException e) {
			throw new WsaException("Can not get wsdl at: " + uri, e);
		} catch (final IOException e) {
			throw new WsaException("Can not get wsdl at: " + uri, e);
		}
		return desc;
    }
	/**
     * Read a EndpointReferanceType XML definition from a {@link File} object
     * into a WS-Addressing JAXB model {@link EndpointReferenceType} instance. (used by persistence feature)
     * 
     * @param file 
     * 		the {@link File} object which the 
     * 		{@link EndpointReferenceType} object must be read from 
     * @return a {@link EndpointReferenceType} Java object instance
     * 
	 * @throws WsaException
     */
    @Override
	public final EndpointReferenceType readEndpointReferenceType(File file) throws WsaException{
		EndpointReferenceType edpRefObj=null;
		try {
			Document endpointRefAsDoc = WsstarCommonUtils.convertFromFiletoDocument(file);
			edpRefObj = this.readEndpointReferenceType(endpointRefAsDoc);
		} catch (WsstarCommonException e) {
			throw new WsaException(e);
		}
		return edpRefObj;
    }
	
}
