/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaWriter;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.WsaJAXBContext;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonUtils;



/**
 *  This class provides a collection of methods that enable conversion of a
 * "WS-Addressing java type" object into a {@link Document} object.
 * This conversion uses JAXB "marshalling" mechanism
 * 
 * @author Thierry DEJEAN - eBM WebSourcing
 */
public class WsaWriterImpl implements WsaWriter{
	
	private final Logger log = Logger.getLogger(WsaWriterImpl.class.getName());
	
	private WsaJAXBContext addressingJaxbContext = null;
	
	/**
     * Default constructor
     * 
     */
    protected WsaWriterImpl(){
		try {
			this.addressingJaxbContext = WsaJAXBContext.getInstance();
		} catch (Exception e) {
			log.log(Level.WARNING, "WS-Addressing Writer initialisation failed !", e);
		}	
	}
    
    protected WsaWriterImpl(String[] nsAndPrefixForMarshalling) {
		try {			
			this.addressingJaxbContext = WsaJAXBContext.getInstance();
			this.addressingJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);	
		} catch (Exception e) {
			this.log.log(Level.WARNING, "WS-Addressing Writer initialisation failed !", e);
		}
	}
   
//    /**
//	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
//	 * or the first access to SingletonHolder.INSTANCE, not before.
//	 */
//    private static class WSAddressingWriterHolder {     	
//		private final static WsaWriterImpl INSTANCE = new WsaWriterImpl();
//	}
//    
//    /**
//	 * Return an unique - respect to the Singleton design pattern - instance  
//	 * of the {@link WSResourceWriter} class.  
//	 * 
//	 * @return a unique WSResourceWriter instance. 
//	 */
//	public static WsaWriterImpl getInstance() {
//		return WSAddressingWriterHolder.INSTANCE;
//	}
//	
//	/**
//	 * Return an unique - respect to the Singleton design pattern - instance  
//	 * of the {@link WSResourceWriter} class.  
//	 * 
//	 * @return a unique WSResourceWriter instance. 
//	 */
//	public static WsaWriterImpl getInstance(String[] nsAndPrefixForMarshalling) {
//		WsaWriterImpl writer =  WSAddressingWriterHolder.INSTANCE;
//		writer.addressingJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);		
//		return writer;
//	}
//	
   
    
	/**	 
	 * marshall to DOM Document 
	 * 
	 * @param def
	 * 		the edp to marshall
	 * @return A {@link Document} representation of specified {@link EndpointReferenceType} object
	 * @throws WsaException
	 */
//    public Document writeEndpointReferenceTypeAsDOM(EndpointReferenceType def) throws WsaException {
//    	Document resAsDOM = null;
//    	
//    
//    	try {
//
//    		Marshaller marshaller = this.addressingJaxbContext.createWSAddressingMarshaller();
//
//    		 resAsDOM = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
//    	
//    		 final JAXBElement<EndpointReferenceType> element = 
//             	new JAXBElement<EndpointReferenceType>(WsaConstants.ENDPOINT_REFERENCE_QNAME,
//             			EndpointReferenceType.class,def);            
//             
//    		 marshaller.marshal(element, resAsDOM);
//    		 
//    	} catch (final JAXBException ex) {
//    		throw new WsaException(
//    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
//    	} catch (final ParserConfigurationException ex) {
//    		throw new WsaException(
//    				"Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
//    	} 
//
//         return resAsDOM;
//    }

    @Override
    public final Document writeEndpointReferenceTypeAsDOM(EndpointReferenceType endpoint) throws WsaException {

    	Document resAsDOM = null;
    	if (endpoint instanceof EndpointReferenceTypeImpl) {
    		try {

    			Marshaller marshaller = this.addressingJaxbContext.createWSAddressingMarshaller();

    			resAsDOM = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument();

    			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> element =
    				WsaJAXBContext.WSA_FACTORY.createEndpointReference(EndpointReferenceTypeImpl.toJaxbModel(endpoint));

    				marshaller.marshal(element, resAsDOM);

    		} catch (final JAXBException ex) {
    			throw new WsaException(
    					"Failed to build XML binding from "+ endpoint.getClass().getSimpleName() + " Api Java classes", ex);
    		} 
    	}
    	return resAsDOM;
    }

    /**
     * Write the specified SchemaImpl definition .
     * 
     * @param wsdlDef
     *            the SchemaImpl definition to be written.
     * @throws WsaException 
     */
//    public String writeEndpointReferenceTypeAsString(EndpointReferenceType def) throws WsaException{
//    	String res = null;
//        
//    	try {
//    		
//    		Marshaller marshaller = this.addressingJaxbContext.createWSAddressingMarshaller();
//
//            final JAXBElement<EndpointReferenceType> element = 
//            	new JAXBElement<EndpointReferenceType>(WsaConstants.ENDPOINT_REFERENCE_QNAME, EndpointReferenceType.class, def);
//   
//            final StringWriter stringWriter = new StringWriter();
//            marshaller.marshal(element, stringWriter);
//       	 
//            res = stringWriter.toString();
//            
//    	}catch (final JAXBException e) {
//            throw new WsaException(
//                    "Failed to build XML binding from Agreement descriptor Java classes", e);
//        }
//    	
//        return res;
//    }
    
    @Override
    public final String writeEndpointReferenceTypeAsString(EndpointReferenceType endpoint) throws WsaException {
    	String res = null;

    	try {

    		Marshaller marshaller = this.addressingJaxbContext.createWSAddressingMarshaller();

    		final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> element = 
    			WsaJAXBContext.WSA_FACTORY.createEndpointReference(EndpointReferenceTypeImpl.toJaxbModel(endpoint));

    		final StringWriter stringWriter = new StringWriter();
    		marshaller.marshal(element, stringWriter);

    		res = stringWriter.toString();

    	}catch (final JAXBException e) {
    		throw new WsaException(
    				"Failed to build XML binding from "+ endpoint.getClass().getSimpleName() + " Api Java classes", e);
    	}

    	return res;
	}
    
    /**
     * Write a given {@link EndpointReferenceType} instance to a file on the file system
     * 
     * @param edpRef the {@link EndpointReferenceType} java object to write on the file system
     * @param filename the file (as {@link File} Java object) which the {@link EndpointReferenceType} instance must be written to
     * 
     * @throws WsaException
     */
//    public void writeEndpointReferenceTypeToFile(EndpointReferenceType edpRef, File file) throws WsaException{
//    	Document edpRefAsDoc = this.writeEndpointReferenceTypeAsDOM(edpRef);
//    	try{
//			// Prepare the DOM document for writing		    
//			Source source = new DOMSource(edpRefAsDoc);
//
//			// Prepare the output file		    		
//			Result result = new StreamResult(file);
//
//			// Write the DOM document to the file
//			Transformer xformer;
//
//			xformer = TransformerFactory.newInstance().newTransformer();
//			xformer.transform(source, result);
//			
//		} catch (TransformerConfigurationException e) {
//			throw new WsaException("Problem occurs during \"persistency\" process",e);
//		} catch (TransformerFactoryConfigurationError e) {
//			throw new WsaException("Problem occurs during \"persistency\" process",e);
//		} catch (TransformerException e) {			
//			throw new WsaException("Problem occurs during \"persistency\" process",e);
//		}
//    }

    @Override
    public final void writeEndpointReferenceTypeToFilesystem(EndpointReferenceType endpoint, String path) throws WsaException {
    	Document edpRefAsDoc = this.writeEndpointReferenceTypeAsDOM(endpoint);
    	try{
			// Prepare the DOM document for writing		    
			Source source = new DOMSource(edpRefAsDoc);

			// Prepare the output file		
			File persist = new File(path);
			if (!persist.exists()) {
				try {
					persist.createNewFile();
				} catch (IOException e) {
					throw new WsaException("The persistance file can not be created respect to given path : \"" + path + "\"",e);
				}
			}        
			
			// Prepare the stream
			Result result = new StreamResult(persist);

			// Write the DOM document to the file
			Transformer xformer;

			xformer = WsstarCommonUtils.getDefaultTransformerFactoryThreadLocal();
			xformer.transform(source, result);
			
		} catch (TransformerConfigurationException e) {
			throw new WsaException("Problem occurs during \"persistency\" process",e);
		} catch (TransformerFactoryConfigurationError e) {
			throw new WsaException("Problem occurs during \"persistency\" process",e);
		} catch (TransformerException e) {			
			throw new WsaException("Problem occurs during \"persistency\" process",e);
		}

    }
}
