/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.refinedabstraction.RefinedWsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.WsaModelFactoryImpl;

public final class WsaUtils {
	
	private WsaUtils(){}
	
	/**
     * a very useful method that convert an "EndpointReferenceType" Object from 
     * 	{@link com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType} 
     * to {@link EndpointReferenceType}
     *  
     * @param jaxbModelEndpointRef the object to convert
     * @param clazz class call originator
     * @return
     */
    public static EndpointReferenceType fromJaxbModelEndpointToApiEndpoint(
    		com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbModelEndpointRef, Class<?> clazz){
    	EndpointReferenceType apiEndpointRef = null;    	
    	try {		
			if (jaxbModelEndpointRef != null) {
				apiEndpointRef = ((WsaModelFactoryImpl)
						((RefinedWsaFactory)
								RefinedWsaFactory.getInstance()).getModel()).createWsaModelEndpointReferenceType(jaxbModelEndpointRef);
			}
		} catch (WsaException e) {
			Logger.getLogger(clazz.getSimpleName()).log(Level.WARNING, "a " + e.getClass().getSimpleName() +
					"exception have been thrown. This is due to a problem during conversion of the endpointReference" +
					"from type \"Jaxb model type\" to type \" api type\"");
		}		
		return apiEndpointRef;		
    }
	
	
}
