/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.MetadataType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.WsaJAXBContext;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.MetadataTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.ReferenceParametersTypeImpl;
import com.ebmwebsourcing.wsstar.jaxb.addressing.AttributedURIType;
import com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class EndpointReferenceTypeImpl
implements EndpointReferenceType {
    private com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbTypeObj;
    private static Logger logger = Logger.getLogger(EndpointReferenceTypeImpl.class.getSimpleName());

    protected EndpointReferenceTypeImpl(URI address) {
        this.jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createEndpointReferenceType();
        this.jaxbTypeObj.setAddress(EndpointReferenceTypeImpl.toAttributedURIType(address));
    }

    protected EndpointReferenceTypeImpl(com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbTypeObj) {
        this.jaxbTypeObj = jaxbTypeObj;
    }

    public final com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType getJaxbTypeObj() {
        return this.jaxbTypeObj;
    }

    public final URI getAddress() {
        URI result = null;
        String uriAsString = this.jaxbTypeObj.getAddress().getValue();
        try {
            result = new URI(uriAsString);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "The \"Address\" field value of the \"EndpointReference\" does not respect the URI Syntax (according to RFC-2396/RFC-2732).\nUri string value is :\n\t " + uriAsString + "\n");
        }
        return result;
    }

    public final void setAddress(URI value) {
        this.jaxbTypeObj.setAddress(EndpointReferenceTypeImpl.toAttributedURIType(value));
    }

    public final com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType getReferenceParameters() {
        ReferenceParametersType jaxbRefParams = this.jaxbTypeObj.getReferenceParameters();
        return jaxbRefParams != null ? new ReferenceParametersTypeImpl(jaxbRefParams.getAny()) : null;
    }

    public final void setReferenceParameters(com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType value) {
        ReferenceParametersType jaxbRefParams = this.jaxbTypeObj.getReferenceParameters();
        if (jaxbRefParams == null) {
            jaxbRefParams = WsaJAXBContext.WSA_FACTORY.createReferenceParametersType();
            this.jaxbTypeObj.setReferenceParameters(jaxbRefParams);
        } else {
            jaxbRefParams.getAny().clear();
        }
        jaxbRefParams.getAny().addAll(value.getAny());
    }

    public final MetadataType getMetadata() {
        com.ebmwebsourcing.wsstar.jaxb.addressing.MetadataType jaxbMetadata = this.jaxbTypeObj.getMetadata();
        return jaxbMetadata != null ? new MetadataTypeImpl(jaxbMetadata.getAny()) : null;
    }

    public final void setMetadata(MetadataType value) {
        com.ebmwebsourcing.wsstar.jaxb.addressing.MetadataType jaxbMetadata = this.jaxbTypeObj.getMetadata();
        if (jaxbMetadata == null) {
            jaxbMetadata = WsaJAXBContext.WSA_FACTORY.createMetadataType();
            this.jaxbTypeObj.setMetadata(jaxbMetadata);
        } else {
            jaxbMetadata.getAny().clear();
        }
        jaxbMetadata.getAny().addAll(value.getAny());
    }

    public final List<Element> getAny() {
        ArrayList<Element> wsExtensions = new ArrayList<Element>();
        List<Object> anyFromJaxbModel = this.jaxbTypeObj.getAny();
        for (Object extItem : anyFromJaxbModel) {
            if (!(extItem instanceof Element)) continue;
            wsExtensions.add((Element)extItem);
        }
        return wsExtensions;
    }

    public final void addAny(Element anyAsElt) {
        this.jaxbTypeObj.getAny().add(anyAsElt);
    }

    public final void addAllAny(List<Element> anyAsElts) {
        this.jaxbTypeObj.getAny().addAll(anyAsElts);
    }

    private static AttributedURIType toAttributedURIType(URI address) {
        AttributedURIType uri = WsaJAXBContext.WSA_FACTORY.createAttributedURIType();
        uri.setValue(address.toString());
        return uri;
    }

    public static com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType toJaxbModel(EndpointReferenceType apiTypeObj) {
        com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbTypeObj = null;
        if (apiTypeObj instanceof EndpointReferenceTypeImpl) {
            jaxbTypeObj = ((EndpointReferenceTypeImpl)apiTypeObj).getJaxbTypeObj();
        } else {
            List any;
            MetadataType metadata;
            jaxbTypeObj = WsaJAXBContext.WSA_FACTORY.createEndpointReferenceType();
            jaxbTypeObj.setAddress(EndpointReferenceTypeImpl.toAttributedURIType(apiTypeObj.getAddress()));
            com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType refParams = apiTypeObj.getReferenceParameters();
            if (refParams != null) {
                jaxbTypeObj.setReferenceParameters(ReferenceParametersTypeImpl.toJaxbModel(refParams));
            }
            if ((metadata = apiTypeObj.getMetadata()) != null) {
                jaxbTypeObj.setMetadata(MetadataTypeImpl.toJaxbModel(metadata));
            }
            if ((any = apiTypeObj.getAny()) != null) {
                jaxbTypeObj.getAny().addAll(any);
            }
        }
        return jaxbTypeObj;
    }
}

