/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaWriter;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.WsaJAXBContext;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WsaWriterImpl
implements WsaWriter {
    private final Logger log = Logger.getLogger(WsaWriterImpl.class.getName());
    private WsaJAXBContext addressingJaxbContext = null;

    protected WsaWriterImpl() {
        try {
            this.addressingJaxbContext = WsaJAXBContext.getInstance();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "WS-Addressing Writer initialisation failed !", e);
        }
    }

    protected WsaWriterImpl(String[] nsAndPrefixForMarshalling) {
        try {
            this.addressingJaxbContext = WsaJAXBContext.getInstance();
            this.addressingJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "WS-Addressing Writer initialisation failed !", e);
        }
    }

    public final Document writeEndpointReferenceTypeAsDOM(EndpointReferenceType endpoint) throws WsaException {
        Document resAsDOM = null;
        if (endpoint instanceof EndpointReferenceTypeImpl) {
            try {
                Marshaller marshaller = this.addressingJaxbContext.createWSAddressingMarshaller();
                resAsDOM = WsstarCommonUtils.getNamespaceDocumentBuilder().newDocument();
                JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> element = WsaJAXBContext.WSA_FACTORY.createEndpointReference(EndpointReferenceTypeImpl.toJaxbModel(endpoint));
                marshaller.marshal(element, (Node)resAsDOM);
            }
            catch (JAXBException ex) {
                throw new WsaException("Failed to build XML binding from " + endpoint.getClass().getSimpleName() + " Api Java classes", (Throwable)ex);
            }
        }
        return resAsDOM;
    }

    public final String writeEndpointReferenceTypeAsString(EndpointReferenceType endpoint) throws WsaException {
        String res = null;
        try {
            Marshaller marshaller = this.addressingJaxbContext.createWSAddressingMarshaller();
            JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> element = WsaJAXBContext.WSA_FACTORY.createEndpointReference(EndpointReferenceTypeImpl.toJaxbModel(endpoint));
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(element, (Writer)stringWriter);
            res = stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new WsaException("Failed to build XML binding from " + endpoint.getClass().getSimpleName() + " Api Java classes", (Throwable)e);
        }
        return res;
    }

    public final void writeEndpointReferenceTypeToFilesystem(EndpointReferenceType endpoint, String path) throws WsaException {
        Document edpRefAsDoc = this.writeEndpointReferenceTypeAsDOM(endpoint);
        try {
            DOMSource source = new DOMSource(edpRefAsDoc);
            File persist = new File(path);
            if (!persist.exists()) {
                try {
                    persist.createNewFile();
                }
                catch (IOException e) {
                    throw new WsaException("The persistance file can not be created respect to given path : \"" + path + "\"", (Throwable)e);
                }
            }
            StreamResult result = new StreamResult(persist);
            Transformer xformer = WsstarCommonUtils.getDefaultTransformerFactoryThreadLocal();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new WsaException("Problem occurs during \"persistency\" process", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new WsaException("Problem occurs during \"persistency\" process", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new WsaException("Problem occurs during \"persistency\" process", (Throwable)e);
        }
    }
}

