package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api;

import javax.xml.namespace.QName;

/**
 * Constants of WS-Resource
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WsnbrConstants {
	
	protected WsnbrConstants() {
		// prevents calls from subclass
        throw new UnsupportedOperationException();
	}
	
	// ============== WS-BrokeredNotification "XML Schema" constants ===========================
	/**
	 * target namespace of WS-BrokeredNotification specification XML schema
	 */
	public static final String WS_BROKERED_NOTIFICATION_NAMESPACE_URI = "http://docs.oasis-open.org/wsn/br-2";

	/**
	 * prefix associated to target namespace of WS-BrokeredNotification specification XML schema
	 */
    public static final String WS_BROKERED_NOTIFICATION_PREFIX = "wsn-br";
    
    /**
     * extra the WS-BaseNotification prefix is different in WS-BrokeredNotification specification !?!
     */
    public static final String WS_BASE_NOTIFICATION_PREFIX = "wsn-b";
    
    //  =============== Operations QNAME Constants (Only those not already defined in WS-BaseNotification) ============
    
    public static final QName DESTROY_REGISTRATION_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "DestroyRegistration", WS_BROKERED_NOTIFICATION_PREFIX);
    
    public static final QName DESTROY_REGISTRATION_RESPONSE_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "DestroyRegistrationResponse",
            WS_BROKERED_NOTIFICATION_PREFIX);    
   
    public static final QName REGISTER_PUBLISHER_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "RegisterPublisher",
            WS_BROKERED_NOTIFICATION_PREFIX);
        
    public static final QName REGISTER_PUBLISHER_RESPONSE_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI,"RegisterPublisherResponse",
            WS_BROKERED_NOTIFICATION_PREFIX);
    // ==================================================================================================================
    
    // =================== Type QNAME constants =========================
  
     public static final QName PUBLISHER_REGISTRATION_REFERENCE_QNAME = new QName (WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "PublisherRegistrationReference",
    		 WS_BROKERED_NOTIFICATION_PREFIX);
         
    public static final QName TOPIC_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "Topic",
            WS_BROKERED_NOTIFICATION_PREFIX);
   
    public static final QName NOTIFICATION_BROKER_RP_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI,"NotificationBrokerRP",
    		WS_BROKERED_NOTIFICATION_PREFIX);

    public static final QName PUBLISHER_REGISTRATION_RP_QNAME = new QName(WS_BROKERED_NOTIFICATION_NAMESPACE_URI,"PublisherRegistrationRP",
    		WS_BROKERED_NOTIFICATION_PREFIX);
    
    // ==================================================================
    
    // ==================== Faults QNAME Constants (Only those not already defined in WS-BaseNotification) ==============
    
    public static final QName PUBLISHER_REGISTRATION_REJECTED_QNAME = new QName(
            WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "PublisherRegistrationRejectedFault" , WS_BROKERED_NOTIFICATION_PREFIX);

    public static final QName PUBLISHER_REGISTRATION_FAILED_QNAME = new QName(
            WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "PublisherRegistrationFailedFault" , WS_BROKERED_NOTIFICATION_PREFIX);        
    
    public static final QName RESOURCE_NOT_DESTROYED_QNAME = new QName(
            WS_BROKERED_NOTIFICATION_NAMESPACE_URI, "ResourceNotDestroyedFault", WS_BROKERED_NOTIFICATION_PREFIX);        
    
    
	// ============== WS-BrokeredNotification "WSDL" constants ===========================
    
    /**
     * target namespace of WS-BrokeredNotification specification wsdl
     */
    public static final String WS_BROKERED_NOTIFICATION_WSDL_NAMESPACE_URI = "http://docs.oasis-open.org/wsn/brw-2";
    
    /**
     * prefix associated to target namespace of WS-BrokeredNotification specification wsdl
     */
    public static final String WS_BROKERED_NOTIFICATION_WSDL_PREFIX = "wsn-brw";
    
    /**
     * extra the WS-BaseNotification prefix is different in WS-BrokeredNotification specification !?!
     */
    public static final String WS_BASE_NOTIFICATION_WSDL_PREFIX = "wsn-bw";
    
    /**
    * The QName of the notification broker interface<br />
    * Imposed by the WS-BrokeredNotification specifications
    */
   
	 public static final QName NOTIFICATION_BROKER_INTERFACE = new QName(
           WS_BROKERED_NOTIFICATION_WSDL_NAMESPACE_URI, "NotificationBroker");

   /**
    * The QName of the publisher registration interface<br />
    * Imposed by the WS-BrokeredNotification specifications
    */
   public static final QName PUBLISHER_REGISTRATION_MANAGER_INTERFACE = new QName(
           WS_BROKERED_NOTIFICATION_WSDL_NAMESPACE_URI, "PublisherRegistrationManager");
 
   // ============= WS-BrokeredNotification specification ~ Publishing patterns ==============
   
   public static final String SIMPLE_PUBLISHING_PATTERN = "simple";
   
   public static final String BROKER_INITIATED_PUBLISHING_PATTERN = "broker-initiated";
   
   public static final String DEMAND_BASED_PUBLISHING_PATTERN = "demand-based";
   
   // ========================================================================================
  
   /**
	 * XML TAG node use to identified a publisher's registration Id in a WS-Addressing
	 * "EndpointReference", when the publisher's registration resource is implemented
	 * as a WS-Resource.
	 * See {@linkplain http://docs.oasis-open.org/wsrf/wsrf-primer-1.2-primer-cd-02.pdf}
	 * (page 7/47 and following ones) for more details
	 */
	public static QName REGISTRATION_ID_QNAME_TAG = new QName("http://www.ebmwebsourcing.com/wsstar/wsnbr/ws-resource","RegistrationId","rpimpl");

}
