package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction;


import java.util.Date;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;

public interface WsnbrFactory {

	// ~~~~~~~~~ Datatype creation methods ~~~~~~~~~~~ 

	DestroyRegistration createDestroyRegistration();

	DestroyRegistrationResponse createDestroyRegistrationResponse();

	NotificationBrokerRP createNotificationBrokerRP(boolean requiresRegistration);

	PublisherRegistrationFailedFaultType createPublisherRegistrationFailedFaultType(Date timestamp);

	PublisherRegistrationRejectedFaultType createPublisherRegistrationRejectedFaultType(Date timestamp);

	PublisherRegistrationRP createPublisherRegistrationRP(boolean isDemand);

	RegisterPublisher createRegisterPublisher();

	RegisterPublisherResponse createRegisterPublisherResponse(EndpointReferenceType registrationRef);

	ResourceNotDestroyedFaultType createResourceNotDestroyedFaultType(Date timestamp);

	// ~~~~~~~~~ Reader/Writer singleton(s) getter ~~~~~~~~~~

	WsnbrReader getWsnbrReader();

	WsnbrWriter getWsnbrWriter();
}
