package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.implementor;


import java.util.Date;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistration;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.NotificationBrokerRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrReader;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrWriter;

public interface WsnbrModelFactory {

	 DestroyRegistration createWsnbrModelDestroyRegistration();
	
	 DestroyRegistrationResponse createWsnbrModelDestroyRegistrationResponse();
	
	 NotificationBrokerRP createWsnbrModelNotificationBrokerRP(boolean requiresRegistration);
	
	 PublisherRegistrationFailedFaultType createWsnbrModelPublisherRegistrationFailedFaultType(Date timestamp);
	
	 PublisherRegistrationRejectedFaultType createWsnbrModelPublisherRegistrationRejectedFaultType(Date timestamp);
	
	 PublisherRegistrationRP createWsnbrModelPublisherRegistrationRP(boolean isDemand);
	
	 RegisterPublisher createWsnbrModelRegisterPublisher();
	
	 RegisterPublisherResponse createWsnbrModelRegisterPublisherResponse(EndpointReferenceType registrationRef);
	
	 ResourceNotDestroyedFaultType createWsnbrModelResourceNotDestroyedFaultType(Date timestamp);
	
	 WsnbrReader getWsnbrModelReader();
	
	 WsnbrWriter getWsnbrModelWriter();
	
}
