package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.refinedabstraction;


import java.util.Date;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistration;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.NotificationBrokerRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrReader;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrWriter;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.implementor.WsnbrModelFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.utils.WsnbrException;

public final class RefinedWsnbrFactory implements WsnbrFactory {
	
	private WsnbrModelFactory model;
	
	//	################# EXPERITMENTAL SINGLETON PATTERN FORM ######################
	
	private RefinedWsnbrFactory () {
	}	

	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
	private static final class WsnbrFactoryHolder { 		
		private  static final RefinedWsnbrFactory INSTANCE = new RefinedWsnbrFactory();	
		
		private WsnbrFactoryHolder(){}
	}

	public static WsnbrFactory getInstance() throws WsnbrException {
		RefinedWsnbrFactory singleton = WsnbrFactoryHolder.INSTANCE;
		if (singleton.model == null){ 			
			throw new WsnbrException("\n\t/!\\ WARNING /!\\\n" +
					"The WsnbrModelFactory have not been initialized !!!\n" +
					"Please create a \"WsnbrModelFactory\" instance and \n" +
					"call the \"getInstance(WsnbrModelFactory)\" method instead." +
					"\n\t/!\\ WARNING /!\\\n");
		}
		return singleton;		
	}	
	
	public static WsnbrFactory getInstance(WsnbrModelFactory modelFactory) {		
		RefinedWsnbrFactory singleton = WsnbrFactoryHolder.INSTANCE;
		singleton.model = modelFactory;		 	
		return singleton;		
	}	 		
	//	#######################################################################
	
	public WsnbrModelFactory getModel() {
		return this.model;
	}
	
	protected void  setModel(WsnbrModelFactory model) {
		this.model = model;
	}
	
	@Override
	public WsnbrReader getWsnbrReader() {
		return this.model.getWsnbrModelReader();
	}

	@Override
	public WsnbrWriter getWsnbrWriter() {
		return this.model.getWsnbrModelWriter();
	}

	@Override
	public DestroyRegistration createDestroyRegistration() {

		return this.model.createWsnbrModelDestroyRegistration() ;
	}

	@Override
	public DestroyRegistrationResponse createDestroyRegistrationResponse() {		
		return this.model.createWsnbrModelDestroyRegistrationResponse() ;
	}

	@Override
	public NotificationBrokerRP createNotificationBrokerRP(boolean requiresRegistration) {
		return this.model.createWsnbrModelNotificationBrokerRP(requiresRegistration) ;
	}

	@Override
	public PublisherRegistrationFailedFaultType createPublisherRegistrationFailedFaultType(
			Date timestamp) {
		return this.model.createWsnbrModelPublisherRegistrationFailedFaultType(timestamp) ;
	}

	@Override
	public PublisherRegistrationRejectedFaultType createPublisherRegistrationRejectedFaultType(
			Date timestamp) {
		return this.model.createWsnbrModelPublisherRegistrationRejectedFaultType(timestamp);
	}

	@Override
	public PublisherRegistrationRP createPublisherRegistrationRP(boolean isDemand) {
		return this.model.createWsnbrModelPublisherRegistrationRP(isDemand) ;
	}

	@Override
	public RegisterPublisher createRegisterPublisher() {
		return this.model.createWsnbrModelRegisterPublisher() ;
	}

	@Override
	public RegisterPublisherResponse createRegisterPublisherResponse(EndpointReferenceType registrationRef) {
		return this.model.createWsnbrModelRegisterPublisherResponse(registrationRef) ;
	}

	@Override
	public ResourceNotDestroyedFaultType createResourceNotDestroyedFaultType(
			Date timestamp) {
		return this.model.createWsnbrModelResourceNotDestroyedFaultType(timestamp) ;
	}
	
	

}
