/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.utils;

import java.util.Locale;

/**
 * 
 * @author tdejean - eBM WebSourcing
 *
 */
public class WsnbrFaultMessageContentConstants {

	protected WsnbrFaultMessageContentConstants(){
		// prevents calls from subclass
        throw new UnsupportedOperationException();
	}
	
	private static final String MESSAGE_NOT_KNOWN_TO_WEB_SERVICE = "message is not known to the Web service.";
	
	public static final Locale FAULT_DESCRIPTION_LANGUAGE = Locale.ENGLISH;	
		
	/**
	 * 	~~~~ WS-BrokeredNotification "RegisterPublisher" fault messages descriptions ~~~~
	 * 						~~~~ (WS-BrokeredNotification - p.21) ~~~~
	 * 
	 *	InvalidTopicExpressionFault
	 *	    •   The TopicExpression presented in the request message is invalid. This fault is specified
	 *	        in WS-BaseNotification.
	 *	PublisherRegistrationFailedFault
	 *	    •   The publisher registration process has failed. The NotificationBroker MAY include a hint
	 * 	        in the fault message indicating why the registration is failed.
	 *	PublisherRegistrationRejectedFault
	 *	    •   The publisher registration is rejected by the NotificationBroker. The NotificationBroker
	 *	        MAY provide a hint in the fault message indicating why the registration is rejected.
	 *	ResourceUnknownFault
	 *	    •   The NotificationBroker is acting as a WS-Resource, and the resource identified in the
	 *	        message is not known to the Web service. This fault is specified by the WS-Resource
	 *	        [WS-Resource] specification.
	 *	TopicNotSupportedFault
	 * 	    •   The TopicExpression does not match any Topic supported by the NotificationBroker. This
	 *	        fault is specified in WS-BaseNotification.
	 *	UnacceptableInitialTerminationTimeFault
	 *	    •   The value of InitialTerminationTime specified in the RegisterPublisher request message
	 *	        is not acceptable to the NotificationBroker. The NotificationBroker MAY include a hint in
	 *	        the fault message indicating why the value is unacceptable.
	 */
	public static class WsnbrRegisterPublisherFaultDescriptions{
		
			protected WsnbrRegisterPublisherFaultDescriptions(){
				// prevents calls from subclass
		        throw new UnsupportedOperationException();
			} 
				
			public static final String INVALID_TOPIC_EXPRESSION_FAULT_DESC = 
				"The TopicExpression presented in the request message is invalid. ";

			public static final String PUBLISHER_REGISTRATION_FAILED_FAULT_DESC = 
				"The publisher registration process has failed.";
				
			public static final String PUBLISHER_REGISTRATION_REJECTED_FAULT_DESC = 
				"The publisher registration is rejected by the NotificationBroker.";

			public static final String RESOURCE_UNKNOWN_FAULT_DESC = 
				"The NotificationBroker is acting as a WS-Resource, and the resource identified in the " +
		        MESSAGE_NOT_KNOWN_TO_WEB_SERVICE;
			
			public static final String RESOURCE_NOT_DESTROYED_FAULT_DESC = 
				"The PublisherRegistrationManager was unable to destroy the PublisherRegistration " +
				"resource for some reason";
			
			public static final String TOPIC_EXPRESSION_DIALECT_UNKNOWN_FAULT_DESC =
				"The RegisterPublisher message contained a TopicExpression having a dialect that was not understood " +
				"or supported by the NotificationBroker.";
			
			public static final String TOPIC_NOT_SUPPORTED_FAULT_DESC = 
				"The TopicExpression does not match any Topic supported by the NotificationBroker.";
			
			public static final String UNACCEPTABLE_INITIAL_TERMINATION_TIME_FAULT_DESC =
				"The value of InitialTerminationTime specified in the RegisterPublisher request message " +
				"is not acceptable to the NotificationBroker.";
	}
	
	/**
	 * ~~~~ WS-BrokeredNotification "DestroyRegistration" fault messages descriptions ~~~~
	 * 						~~~~~ (WS-BerokeredNOtification - p.26)~~~~~
	 * 
	 *	ResourceNotDestroyedFault
	 *	   •   The PublisherRegistrationManager was unable to destroy the PublisherRegistration
	 *	       resource for some reason.
	 *  ResourceUnknownFault
	 *	   •   The PublisherRegistration is a WS-Resource, and the resource identified in the message
	 *	       is not known to the Web service. This fault is specified by the WS-Resource [WS-
	 *	       Resource] specification.
	 */
	public static class WsnbrDestroyRegistrationFaultDescriptions{
		
		protected WsnbrDestroyRegistrationFaultDescriptions(){
			// prevents calls from subclass
	        throw new UnsupportedOperationException();
		}
		
		public static final String RESOURCE_NOT_DESTROYED_FAULT_DESC = 
			"The PublisherRegistrationManager was unable to destroy the PublisherRegistration " +
			"resource for some reason";

		public static final String RESOURCE_UNKNOWN_FAULT_DESC = 
			"The PublisherRegistration is a WS-Resource, and the resource identified in the " +
			MESSAGE_NOT_KNOWN_TO_WEB_SERVICE;

	}
}
