/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.BaseFaultType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.AbsWsrfbfTypesUnitTests;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.test.WsnbUnitTestsUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrReader;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrWriter;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.implementor.WsnbrModelFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.refinedabstraction.RefinedWsnbrFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.test.WsnbrUnitTestsUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.utils.WsnbrException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbsWsnbrFaultsUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsnbrFactory factory;
    protected WsnbrModelFactory modelFactoryImpl;
    private WsnbrReader reader;
    private WsnbrWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsnbrFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsnbrModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsnbrFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsnbrModelFactory();
        }
        AbsWsnbrFaultsUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "the \"WsnbrModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsnbrModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsnbrFactory.getInstance((WsnbrModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsnbrReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsnbrWriter();
        }
    }

    protected static boolean checkPublisherRegistrationFailedFaultType(PublisherRegistrationFailedFaultType expectedFault, PublisherRegistrationFailedFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
    }

    protected static boolean checkPublisherRegistrationRejectedFaultType(PublisherRegistrationRejectedFaultType expectedFault, PublisherRegistrationRejectedFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
    }

    protected static boolean checkResourceNotDestroyedFaultType(ResourceNotDestroyedFaultType expectedFault, ResourceNotDestroyedFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
    }

    @Test
    public final void testCreateWriteAsDOMReadPublisherRegistrationFailedFaultType() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM PublisherRegistrationFailedFaultType\" ~~~~~~~ \n");
        try {
            QName unknownFilterQname = new QName("http://www.ebmwebsourcing.com/wsn/faults/filter", "UnknownFilterValue");
            ArrayList<QName> unknownFilters = new ArrayList<QName>();
            unknownFilters.add(unknownFilterQname);
            PublisherRegistrationFailedFaultType fault = this.factory.createPublisherRegistrationFailedFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)fault, (EndpointReferenceType)WsnbUnitTestsUtils.createDefaultWsnProducerOriginator(), (String)"The publisher registration process has failed.", (Locale)Locale.ENGLISH, (String)"WSNBR-FAULT-1", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsn/errors"), null);
            Document faultAsDOM = this.writer.writePublisherRegistrationFailedFaultTypeAsDOM(fault);
            try {
                WsaUnitTestsUtils.validateResult((Document)faultAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BrokeredNotification\"", PublisherRegistrationFailedFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + e.getMessage()));
            }
            PublisherRegistrationFailedFaultType readFault = this.reader.readPublisherRegistrationFailedFaultType(faultAsDOM);
            AbsWsnbrFaultsUnitTests.checkPublisherRegistrationFailedFaultType(fault, readFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM PublisherRegistrationFailedFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        catch (WsaException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadPublisherRegistrationRejectedFaultType() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM PublisherRegistrationRejectedFaultType\" ~~~~~~~ \n");
        try {
            QName unknownFilterQname = new QName("http://www.ebmwebsourcing.com/wsn/faults/filter", "UnknownFilterValue");
            ArrayList<QName> unknownFilters = new ArrayList<QName>();
            unknownFilters.add(unknownFilterQname);
            PublisherRegistrationRejectedFaultType fault = this.factory.createPublisherRegistrationRejectedFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)fault, (EndpointReferenceType)WsnbUnitTestsUtils.createDefaultWsnProducerOriginator(), (String)"The publisher registration is rejected by the NotificationBroker.", (Locale)Locale.ENGLISH, (String)"WSNBR-FAULT-2", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsn/errors"), null);
            Document faultAsDOM = this.writer.writePublisherRegistrationRejectedFaultTypeAsDOM(fault);
            try {
                WsaUnitTestsUtils.validateResult((Document)faultAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BrokeredNotification\"", PublisherRegistrationRejectedFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + e.getMessage()));
            }
            PublisherRegistrationRejectedFaultType readFault = this.reader.readPublisherRegistrationRejectedFaultType(faultAsDOM);
            AbsWsnbrFaultsUnitTests.checkPublisherRegistrationRejectedFaultType(fault, readFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM PublisherRegistrationRejectedFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        catch (WsaException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadResourceNotDestroyedFaultType() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM ResourceNotDestroyedFaultType\" ~~~~~~~ \n");
        try {
            QName unknownFilterQname = new QName("http://www.ebmwebsourcing.com/wsn/faults/filter", "UnknownFilterValue");
            ArrayList<QName> unknownFilters = new ArrayList<QName>();
            unknownFilters.add(unknownFilterQname);
            ResourceNotDestroyedFaultType fault = this.factory.createResourceNotDestroyedFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)fault, (EndpointReferenceType)WsnbUnitTestsUtils.createDefaultWsnProducerOriginator(), (String)"The PublisherRegistrationManager was unable to destroy the PublisherRegistration resource for some reason", (Locale)Locale.ENGLISH, (String)"WSNBR-FAULT-3", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsn/errors"), null);
            Document faultAsDOM = this.writer.writeResourceNotDestroyedFaultTypeAsDOM(fault);
            try {
                WsaUnitTestsUtils.validateResult((Document)faultAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BrokeredNotification\"", ResourceNotDestroyedFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + e.getMessage()));
            }
            ResourceNotDestroyedFaultType readFault = this.reader.readResourceNotDestroyedFaultType(faultAsDOM);
            AbsWsnbrFaultsUnitTests.checkResourceNotDestroyedFaultType(fault, readFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ResourceNotDestroyedFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        catch (WsaException e1) {
            e1.printStackTrace();
        }
    }
}

