/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.AbsWsaTypesUnitTests;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.test.AbsWsnbTypesAndPayloadsUnitTests;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.test.WsnbUnitTestsUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistration;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrReader;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrWriter;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.implementor.WsnbrModelFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.refinedabstraction.RefinedWsnbrFactory;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.test.WsnbrUnitTestsUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.utils.WsnbrException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbsWsnbrTypesAndPayloadsUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsnbrFactory factory;
    protected WsnbrModelFactory modelFactoryImpl;
    private WsnbrReader reader;
    private WsnbrWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsnbrFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsnbrModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsnbrFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsnbrModelFactory();
        }
        AbsWsnbrTypesAndPayloadsUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "the \"WsnbModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsnbrModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsnbrFactory.getInstance((WsnbrModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsnbrReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsnbrWriter();
        }
    }

    protected PublisherRegistrationRP createDefaultPublisherRegistrationRP() throws WsnbrException {
        TopicExpressionType topic;
        PublisherRegistrationRP registration = this.factory.createPublisherRegistrationRP(true);
        EndpointReferenceType publisherRef = null;
        try {
            publisherRef = WsnbUnitTestsUtils.createDefaultWsnProducerOriginator();
        }
        catch (URISyntaxException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        catch (WsaException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        registration.setPublisherReference(publisherRef);
        ArrayList<QName> tnss = new ArrayList<QName>();
        tnss.add(new QName("http://default/namespace/for/topic", "tns1"));
        try {
            topic = WsnbUnitTestsUtils.createDefaultTopicExpression((URI)WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI, (String)"tns1:rootTopic/*/grandChildTopic1", tnss);
        }
        catch (WsnbException e) {
            throw new WsnbrException((Throwable)e);
        }
        registration.addTopic(topic);
        registration.setCreationTime(new Date());
        return registration;
    }

    protected static boolean checkDestroyRegistration(DestroyRegistration expectedDestroyRegistration, DestroyRegistration toCheckDestroyRegistration, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckDestroyRegistration : " + (toCheckDestroyRegistration != null ? toCheckDestroyRegistration.toString() : "null") + "\n[DEBUG] --> expectedDestroyRegistration : " + (expectedDestroyRegistration != null ? expectedDestroyRegistration.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "DestroyRegistration are \n" + "\t(-> toCheckDestroyRegistration : " + (toCheckDestroyRegistration != null ? toCheckDestroyRegistration.toString() : "null") + "\n\t-> expectedDestroyRegistration : " + (expectedDestroyRegistration != null ? expectedDestroyRegistration.toString() : "null") + ")"), (toCheckDestroyRegistration != null && expectedDestroyRegistration != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkDestroyRegistrationResponse(DestroyRegistrationResponse expectedDestroyRegistrationResponse, DestroyRegistrationResponse toCheckDestroyRegistrationResponse, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckDestroyRegistrationResponse : " + (toCheckDestroyRegistrationResponse != null ? toCheckDestroyRegistrationResponse.toString() : "null") + "\n[DEBUG] --> expectedDestroyRegistrationResponse : " + (expectedDestroyRegistrationResponse != null ? expectedDestroyRegistrationResponse.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "DestroyRegistrationResponse are \n" + "\t(-> toCheckDestroyRegistrationResponse : " + (toCheckDestroyRegistrationResponse != null ? toCheckDestroyRegistrationResponse.toString() : "null") + "\n\t-> expectedDestroyRegistrationResponse : " + (expectedDestroyRegistrationResponse != null ? expectedDestroyRegistrationResponse.toString() : "null") + ")"), (toCheckDestroyRegistrationResponse != null && expectedDestroyRegistrationResponse != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkPublisherRegistrationRP(PublisherRegistrationRP expectedRegistration, PublisherRegistrationRP toCheckRegistration, boolean isDebug) {
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "PublisherReference must not be null ! \n" + "\t(-> toCheckRegistration \"isDemand\" value is " + toCheckRegistration.isDemand() + "\n\t-> expectedRegistration \"isDemand\" value is " + toCheckRegistration.isDemand() + ")"), (toCheckRegistration.isDemand() && expectedRegistration.isDemand() || !toCheckRegistration.isDemand() && !expectedRegistration.isDemand() ? 1 : 0) != 0);
        EndpointReferenceType toCheckPublisherRef = toCheckRegistration.getPublisherReference();
        EndpointReferenceType expectedPublisherRef = expectedRegistration.getPublisherReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "PublisherReference are differents \n" + "\t(-> toCheckPublisherRef is " + (toCheckPublisherRef != null ? "not null" : "null") + "\n\t-> expectedPublisherRef is " + (expectedPublisherRef != null ? "not null" : "null") + ")"), (toCheckPublisherRef == null && expectedPublisherRef == null || toCheckPublisherRef != null && expectedPublisherRef != null ? 1 : 0) != 0);
        if (toCheckPublisherRef != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedPublisherRef, (EndpointReferenceType)toCheckPublisherRef, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
        }
        List toCheckTopics = toCheckRegistration.getTopics();
        List expectedTopics = expectedRegistration.getTopics();
        int expectedTopicsCount = expectedTopics != null ? expectedTopics.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "Registration have different Topics \n" + "\t(-> toCheckRegistration Topics count : " + (toCheckTopics != null ? Integer.valueOf(toCheckTopics.size()) : "none") + "\n\t-> expectedRegistration Topics count : " + (expectedTopicsCount == -1 ? "none" : Integer.valueOf(expectedTopicsCount)) + ")"), (expectedTopics == null && toCheckTopics == null || toCheckTopics.size() == expectedTopicsCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedTopicsCount; ++i) {
            TopicExpressionType toCheckTopic = (TopicExpressionType)toCheckTopics.get(i);
            TopicExpressionType expectedTopic = (TopicExpressionType)expectedTopics.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] \t ~~~~ Registration Topic (# " + i + ") details : ~~~~\n");
            }
            AbsWsnbTypesAndPayloadsUnitTests.checkTopicExpressionType((TopicExpressionType)expectedTopic, (TopicExpressionType)toCheckTopic, (boolean)isDebug);
            if (!isDebug) continue;
            System.out.println("[DEBUG] \t\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        Date toCheckCreationTime = toCheckRegistration.getCreationTime();
        Date expectedCreationTime = expectedRegistration.getCreationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "Registration have different CreationTime \n" + "\t(-> toCheckCreationTime is " + (toCheckCreationTime != null ? "not null" : "null") + "\n\t-> expectedCreationTime is " + (expectedCreationTime != null ? "not null" : "null") + ")"), (toCheckCreationTime == null && expectedCreationTime == null || toCheckCreationTime != null && expectedCreationTime != null ? 1 : 0) != 0);
        if (toCheckCreationTime != null) {
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckCreationTime value is : " + toCheckCreationTime.getTime() + "\n[DEBUG] --> expectedCreationTime value is : " + expectedCreationTime.getTime() + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "Registration have different CreationTime value\n" + "\t(-> toCheckCreationTime value is " + toCheckCreationTime.getTime() + "\n\t-> expectedCreationTime value is " + expectedCreationTime.getTime() + ")"), (boolean)toCheckCreationTime.equals(expectedCreationTime));
        }
        return true;
    }

    protected static boolean checkRegisterPublisher(RegisterPublisher expectedPayload, RegisterPublisher toCheckPayload, boolean isDebug) {
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "PublisherReference must not be null ! \n" + "\t(-> toCheckPayload \"isDemand\" value is " + toCheckPayload.isDemand() + "\n\t-> expectedPayload \"isDemand\" value is " + toCheckPayload.isDemand() + ")"), (toCheckPayload.isDemand() && expectedPayload.isDemand() || !toCheckPayload.isDemand() && !expectedPayload.isDemand() ? 1 : 0) != 0);
        EndpointReferenceType toCheckPublisherRef = toCheckPayload.getPublisherReference();
        EndpointReferenceType expectedPublisherRef = expectedPayload.getPublisherReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "PublisherReference are differents \n" + "\t(-> toCheckPublisherRef is " + (toCheckPublisherRef != null ? "not null" : "null") + "\n\t-> expectedPublisherRef is " + (expectedPublisherRef != null ? "not null" : "null") + ")"), (toCheckPublisherRef == null && expectedPublisherRef == null || toCheckPublisherRef != null && expectedPublisherRef != null ? 1 : 0) != 0);
        if (toCheckPublisherRef != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedPublisherRef, (EndpointReferenceType)toCheckPublisherRef, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
        }
        List toCheckTopics = toCheckPayload.getTopics();
        List expectedTopics = expectedPayload.getTopics();
        int expectedTopicsCount = expectedTopics != null ? expectedTopics.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "Payload have different Topics \n" + "\t(-> toCheckPayload Topics count : " + (toCheckTopics != null ? Integer.valueOf(toCheckTopics.size()) : "none") + "\n\t-> expectedPayload Topics count : " + (expectedTopicsCount == -1 ? "none" : Integer.valueOf(expectedTopicsCount)) + ")"), (expectedTopics == null && toCheckTopics == null || toCheckTopics.size() == expectedTopicsCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedTopicsCount; ++i) {
            TopicExpressionType toCheckTopic = (TopicExpressionType)toCheckTopics.get(i);
            TopicExpressionType expectedTopic = (TopicExpressionType)expectedTopics.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] \t ~~~~ Payload Topic (# " + i + ") details : ~~~~\n");
            }
            AbsWsnbTypesAndPayloadsUnitTests.checkTopicExpressionType((TopicExpressionType)expectedTopic, (TopicExpressionType)toCheckTopic, (boolean)isDebug);
            if (!isDebug) continue;
            System.out.println("[DEBUG] \t\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        Date toCheckCreationTime = toCheckPayload.getInitialTerminationTime();
        Date expectedCreationTime = expectedPayload.getInitialTerminationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "Payload have different CreationTime \n" + "\t(-> toCheckCreationTime is " + (toCheckCreationTime != null ? "not null" : "null") + "\n\t-> expectedCreationTime is " + (expectedCreationTime != null ? "not null" : "null") + ")"), (toCheckCreationTime == null && expectedCreationTime == null || toCheckCreationTime != null && expectedCreationTime != null ? 1 : 0) != 0);
        if (toCheckCreationTime != null) {
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckCreationTime value is : " + toCheckCreationTime.getTime() + "\n[DEBUG] --> expectedCreationTime value is : " + expectedCreationTime.getTime() + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "Payload have different CreationTime value\n" + "\t(-> toCheckCreationTime value is " + toCheckCreationTime.getTime() + "\n\t-> expectedCreationTime value is " + expectedCreationTime.getTime() + ")"), (boolean)toCheckCreationTime.equals(expectedCreationTime));
        }
        return true;
    }

    protected static boolean checkRegisterPublisherResponse(RegisterPublisherResponse expectedPayload, RegisterPublisherResponse toCheckPayload, boolean isDebug) {
        EndpointReferenceType toCheckRegistrationPublisherRef = toCheckPayload.getPublisherRegistrationReference();
        EndpointReferenceType expectedRegistrationRef = expectedPayload.getPublisherRegistrationReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "PublisherReference are differents \n" + "\t(-> toCheckPublisherRegistrationRef is " + (toCheckRegistrationPublisherRef != null ? "not null" : "null") + "\n\t-> expectedPublisherRegistrationRef is " + (expectedRegistrationRef != null ? "not null" : "null") + ")"), (toCheckRegistrationPublisherRef == null && expectedRegistrationRef == null || toCheckRegistrationPublisherRef != null && expectedRegistrationRef != null ? 1 : 0) != 0);
        if (toCheckRegistrationPublisherRef != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedRegistrationRef, (EndpointReferenceType)toCheckRegistrationPublisherRef, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
        }
        EndpointReferenceType toCheckConsumerRef = toCheckPayload.getConsumerReference();
        EndpointReferenceType expectedConsumerRef = expectedPayload.getConsumerReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "PublisherReference are differents \n" + "\t(-> toCheckConsumerRef is " + (toCheckConsumerRef != null ? "not null" : "null") + "\n\t-> expectedConsumerRef is " + (expectedConsumerRef != null ? "not null" : "null") + ")"), (toCheckConsumerRef == null && expectedConsumerRef == null || toCheckConsumerRef != null && expectedConsumerRef != null ? 1 : 0) != 0);
        if (toCheckConsumerRef != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedConsumerRef, (EndpointReferenceType)toCheckConsumerRef, (String)"OASIS \"WS-BrokeredNotification\"", (boolean)isDebug);
        }
        return true;
    }

    @Test
    public final void testCreateWriteAsDOMDestroyRegistration() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM DestroyRegistration\" ~~~~~~~ \n");
        DestroyRegistration payload = this.factory.createDestroyRegistration();
        Document payloadAsDOM = this.writer.writeDestroyRegistrationAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", DestroyRegistration.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        DestroyRegistration readPayload = this.reader.readDestroyRegistration(payloadAsDOM);
        AbsWsnbrTypesAndPayloadsUnitTests.checkDestroyRegistration(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM DestroyRegistration\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMDestroyRegistrationResponse() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM DestroyRegistrationResponse\" ~~~~~~~ \n");
        DestroyRegistrationResponse payload = this.factory.createDestroyRegistrationResponse();
        Document payloadAsDOM = this.writer.writeDestroyRegistrationResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", DestroyRegistrationResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        DestroyRegistrationResponse readPayload = this.reader.readDestroyRegistrationResponse(payloadAsDOM);
        AbsWsnbrTypesAndPayloadsUnitTests.checkDestroyRegistrationResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM DestroyRegistrationResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMPublisherRegistrationRP() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM PublisherRegistrationRP\" ~~~~~~~ \n");
        PublisherRegistrationRP registration = this.createDefaultPublisherRegistrationRP();
        Document registrationAsDOM = this.writer.writePublisherRegistrationRPAsDOM(registration);
        try {
            WsaUnitTestsUtils.validateResult((Document)registrationAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BrokeredNotification\"", PublisherRegistrationRP.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + e.getMessage()));
        }
        PublisherRegistrationRP readRegistration = this.reader.readPublisherRegistrationRP(registrationAsDOM);
        AbsWsnbrTypesAndPayloadsUnitTests.checkPublisherRegistrationRP(registration, readRegistration, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM PublisherRegistrationRP \" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteToFSReadFromFSEnpointReferenceType() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-Filesystem and read-from-Filesystem PublisherRegistrationRP\" ~~~~~~~ \n");
        File persistenceRepository = WsaUnitTestsUtils.createTempTestDirectory((String)"SaveRegistrations");
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "the persistence directory has not been found on filesystem !"), (persistenceRepository.exists() && persistenceRepository.isDirectory() ? 1 : 0) != 0);
        PublisherRegistrationRP defaultRegistration = this.createDefaultPublisherRegistrationRP();
        String registrationFileName = "registration-" + UUID.randomUUID().toString();
        this.writer.writePublisherRegistrationRPToFilesystem(defaultRegistration, persistenceRepository.getAbsolutePath() + File.separatorChar + registrationFileName);
        File registrationAsFile = new File(persistenceRepository.getAbsolutePath() + File.separatorChar + registrationFileName);
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + "The subscription has not been written on Filesystem\n" + "\tNo file named \"" + registrationFileName + "\" has been found"), (registrationAsFile.exists() && registrationAsFile.length() > 0L ? 1 : 0) != 0);
        System.out.println("\t Unit Test Step 1 (\"create\" and \"write to Filesystem\") passed !\n");
        PublisherRegistrationRP readRegistration = this.reader.readPublisherRegistrationRP(registrationAsFile);
        AbsWsnbrTypesAndPayloadsUnitTests.checkPublisherRegistrationRP(defaultRegistration, readRegistration, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from Filesystem\") passed !");
        if (!this.isDebug) {
            WsaUnitTestsUtils.deleteExistingTestDirectory((File)persistenceRepository);
        }
        System.out.println("\n\t OK, unit test \"Create, Write-to-Filesystem and read-from-Filesystem PublisherRegistrationRP\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    public final void testCreateWriteAsDOMRegisterPublisher() throws WsnbrException {
        TopicExpressionType topic;
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM RegisterPublisher \" ~~~~~~~ \n");
        RegisterPublisher payload = this.factory.createRegisterPublisher();
        EndpointReferenceType publisherRef = null;
        try {
            publisherRef = WsnbUnitTestsUtils.createDefaultWsnProducerOriginator();
        }
        catch (URISyntaxException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        catch (WsaException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        payload.setPublisherReference(publisherRef);
        ArrayList<QName> tnss = new ArrayList<QName>();
        tnss.add(new QName("http://default/namespace/for/topic", "tns1"));
        try {
            topic = WsnbUnitTestsUtils.createDefaultTopicExpression((URI)WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI, (String)"tns1:rootTopic/*/grandChildTopic1", tnss);
        }
        catch (WsnbException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        payload.addTopic(topic);
        GregorianCalendar gCal = new GregorianCalendar();
        gCal.add(10, 2);
        payload.setInitialTerminationTime(gCal.getTime());
        Document payloadAsDOM = this.writer.writeRegisterPublisherAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BrokeredNotification\"", RegisterPublisher.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + e.getMessage()));
        }
        RegisterPublisher readPayload = this.reader.readRegisterPublisher(payloadAsDOM);
        AbsWsnbrTypesAndPayloadsUnitTests.checkRegisterPublisher(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM RegisterPublisher\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    public final void testCreateWriteAsDOMRegisterPublisherResponse() throws WsnbrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM RegisterPublisherResponse \" ~~~~~~~ \n");
        EndpointReferenceType registrationRef = null;
        try {
            registrationRef = WsnbrUnitTestsUtils.createDefaultWsnRegistrationReference();
        }
        catch (URISyntaxException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        catch (WsaException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        RegisterPublisherResponse payload = this.factory.createRegisterPublisherResponse(registrationRef);
        EndpointReferenceType consumerRef = null;
        try {
            consumerRef = WsnbUnitTestsUtils.createDefaultWsnConsumerOriginator();
        }
        catch (URISyntaxException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        catch (WsaException e1) {
            throw new WsnbrException((Throwable)e1);
        }
        payload.setConsumerReference(consumerRef);
        Document payloadAsDOM = this.writer.writeRegisterPublisherResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbrUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BrokeredNotification\"", RegisterPublisherResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BrokeredNotification\"") + e.getMessage()));
        }
        RegisterPublisherResponse readPayload = this.reader.readRegisterPublisherResponse(payloadAsDOM);
        AbsWsnbrTypesAndPayloadsUnitTests.checkRegisterPublisherResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM RegisterPublisherResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }
}

