/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.refinedabstraction.RefinedWsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.WsnbrConstants;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsnbrUnitTestsUtils {
    public static final String WSTOP_SPECIFICATION_NAME = "OASIS \"WS-Topics\"";
    public static final String WSTOP_XML_SCHEMA_PATH = "/schemas/t-1.xsd";
    public static final String WSNB_SPECIFICATION_NAME = "OASIS \"WS-BaseNotification\"";
    public static final String WSNB_XML_SCHEMA_PATH = "/schemas/b-2.xsd";
    public static final String WSNBR_SPECIFICATION_NAME = "OASIS \"WS-BrokeredNotification\"";
    public static final String WSNBR_XML_SCHEMA_PATH = "/schemas/br-2.xsd";
    public static final String[] WSN_XML_SCHEMAS_PATHS = new String[]{"/schema/ws-addr.xsd", "/schemas/xml.xsd", "/schemas/bf-2.xsd", "/schemas/t-1.xsd", "/schemas/b-2.xsd", "/schemas/br-2.xsd"};

    public static EndpointReferenceType createDefaultWsnBrokerOriginator() throws URISyntaxException, WsaException {
        EndpointReferenceType defaultMinimalEdp = null;
        URI address = new URI("http://www.anonymous.com/wsn/default::NotificationBroker@wsn-broker-edp");
        defaultMinimalEdp = RefinedWsaFactory.getInstance().createEndpointReferenceType(address);
        return defaultMinimalEdp;
    }

    public static EndpointReferenceType createDefaultWsnRegistrationReference() throws URISyntaxException, WsaException {
        Document document;
        EndpointReferenceType defaultMinimalEdp = null;
        URI address = new URI("http://www.anonymous.com/wsn/resource/registration::PublisherRegistrationManagerService@PublisherRegistrationManagerServiceEndpoint");
        defaultMinimalEdp = RefinedWsaFactory.getInstance().createEndpointReferenceType(address);
        ReferenceParametersType refparams = RefinedWsaFactory.getInstance().createReferenceParametersType();
        Element subscriptionUuidElt = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try {
            document = dbFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WsaException((Throwable)e);
        }
        subscriptionUuidElt = document.createElementNS(WsnbrConstants.REGISTRATION_ID_QNAME_TAG.getNamespaceURI(), WsnbrConstants.REGISTRATION_ID_QNAME_TAG.getLocalPart());
        subscriptionUuidElt.setPrefix(WsnbrConstants.REGISTRATION_ID_QNAME_TAG.getPrefix());
        subscriptionUuidElt.setTextContent("1255aefe-fbeb-0b0a-ae50-f2ac36bdc942");
        refparams.addAny(subscriptionUuidElt);
        defaultMinimalEdp.setReferenceParameters(refparams);
        return defaultMinimalEdp;
    }
}

