/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.WsnbrJAXBContext;

/**
 * @author Thierry DÉJEAN - eBM WebSourcing
 */
public class PublisherRegistrationFailedFaultTypeImpl extends BaseFaultTypeImpl
		implements PublisherRegistrationFailedFaultType {
	
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link PublisherRegistrationFailedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected PublisherRegistrationFailedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(PublisherRegistrationFailedFaultTypeImpl.class.getSimpleName()));
		
		com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType jaxbTypeObj = 
			new com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected PublisherRegistrationFailedFaultTypeImpl(com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(PublisherRegistrationFailedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType}
	 *  "Jaxb model type" object from a {@link PublisherRegistrationFailedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType toJaxbModel(PublisherRegistrationFailedFaultType apiTypeObj){

		com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof PublisherRegistrationFailedFaultTypeImpl) {
			jaxbTypeObj = (com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType)
			((PublisherRegistrationFailedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createPublisherRegistrationFailedFaultType());
		}
		return jaxbTypeObj;
	}
}
