/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.datatype.XMLGregorianCalendar;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.utils.WsaUtils;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.utils.WsnbUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.WsnbrJAXBContext;

/**
 * @author Thierry DÉJEAN - eBM WebSourcing
 */
public class RegisterPublisherImpl implements RegisterPublisher {
	
	private com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher jaxbTypeObj;
	private static Logger logger  = Logger.getLogger(RegisterPublisherImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected RegisterPublisherImpl() {		
		this.jaxbTypeObj = WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createRegisterPublisher();		
		this.jaxbTypeObj.setDemand(false);
	}

	protected RegisterPublisherImpl(com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public final EndpointReferenceType getPublisherReference() {
		EndpointReferenceType publisherRef = null;
		com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbEndpointRef = 
			this.jaxbTypeObj.getPublisherReference();
		if (jaxbEndpointRef != null){
			publisherRef = WsaUtils.fromJaxbModelEndpointToApiEndpoint(jaxbEndpointRef, this.getClass());
		}
		return publisherRef ;
	}

	@Override
	public final void setPublisherReference(EndpointReferenceType publisherRef) {
		this.jaxbTypeObj.setPublisherReference(EndpointReferenceTypeImpl.toJaxbModel(publisherRef));
	}

	@Override
	public final boolean isDemand() {
		return this.jaxbTypeObj.isDemand();
	}

	@Override
	public final void setDemand(boolean value) {
		this.jaxbTypeObj.setDemand(value);
	}

	@Override
	public final List<TopicExpressionType> getTopics() {
		List<TopicExpressionType> topics = new ArrayList<TopicExpressionType>();
		List<com.ebmwebsourcing.wsstar.jaxb.notification.base.TopicExpressionType> jaxbTopics = 
			this.jaxbTypeObj.getTopic();
		if (jaxbTopics != null){
			for (com.ebmwebsourcing.wsstar.jaxb.notification.base.TopicExpressionType topicItem : jaxbTopics) {
				topics.add(WsnbUtils.fromJaxbModelTopicExpressionToApiTopicExpression(topicItem, this.getClass()));
			}		
		}
		return topics;
	}
	
	@Override
	public final void addTopic(TopicExpressionType topic) {
		this.jaxbTypeObj.getTopic().add(TopicExpressionTypeImpl.toJaxbModel(topic));
	}

	@Override
	public final Date getInitialTerminationTime() {
		Date initTermTime = null;
		XMLGregorianCalendar jaxbCreationTime = this.jaxbTypeObj.getInitialTerminationTime();
		if (jaxbCreationTime != null) {
			initTermTime = jaxbCreationTime.toGregorianCalendar().getTime();
		}
		return initTermTime;
	}

	@Override
	public final void setInitialTerminationTime(Date value) {
		this.jaxbTypeObj.setInitialTerminationTime(WsrfbfUtils.toXMLGregorianCalendar(value, RegisterPublisherImpl.logger));
	}

	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.notification.brokered.RegisterPublisher}
	 *  "Jaxb model type" object from a {@link RegisterPublisher} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher toJaxbModel(RegisterPublisher apiTypeObj) {

		com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher jaxbTypeObj = null;
		
		if (apiTypeObj instanceof RegisterPublisherImpl){
			jaxbTypeObj = ((RegisterPublisherImpl)apiTypeObj).getJaxbTypeObj();
		} else { 
			jaxbTypeObj = WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createRegisterPublisher();

			// ~~~~ set isDemand ~~~~~~ 
			jaxbTypeObj.setDemand(apiTypeObj.isDemand());
			
			// ~~~~ set PublisherReference ~~~~
			EndpointReferenceType apiPublisherRef = apiTypeObj.getPublisherReference();
			if (apiPublisherRef != null){
				jaxbTypeObj.setPublisherReference(EndpointReferenceTypeImpl.toJaxbModel(apiPublisherRef));
			}
			// ~~~~ Set Topics ~~~~~
			List<TopicExpressionType> apiTopics = apiTypeObj.getTopics();
			if (apiTopics != null){
				for (TopicExpressionType topicItem : apiTopics) {
					jaxbTypeObj.getTopic().add((TopicExpressionTypeImpl.toJaxbModel(topicItem)));
				}
			}
			//~~~~~ Set InitialTerminationTime ~~~~~
			Date apiInitialTermTime = apiTypeObj.getInitialTerminationTime();
			if (apiInitialTermTime != null){
				jaxbTypeObj.setInitialTerminationTime(WsrfbfUtils.toXMLGregorianCalendar(apiInitialTermTime,
						RegisterPublisherImpl.logger));
			}
		}
		return jaxbTypeObj;
	}
}
