package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.utils.WsaUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.WsnbrJAXBContext;

public class RegisterPublisherResponseImpl implements RegisterPublisherResponse {
	
	private com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse jaxbTypeObj;
	
	/**
	 * Default constructor
	 */
	protected RegisterPublisherResponseImpl(EndpointReferenceType registrationRef) {		
		this.jaxbTypeObj = WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createRegisterPublisherResponse();		
		this.jaxbTypeObj.setPublisherRegistrationReference(EndpointReferenceTypeImpl.toJaxbModel(registrationRef));
	}

	protected RegisterPublisherResponseImpl(com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse getJaxbTypeObj() {
		return jaxbTypeObj;
	}
		
	@Override
	public final EndpointReferenceType getPublisherRegistrationReference() {
		EndpointReferenceType registrationRef = null;
		com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbEndpointRef = 
			this.jaxbTypeObj.getPublisherRegistrationReference();
		if (jaxbEndpointRef != null){
			registrationRef = WsaUtils.fromJaxbModelEndpointToApiEndpoint(jaxbEndpointRef, this.getClass());
		}
		return registrationRef ;
	}

	@Override
	public final void setPublisherRegistrationReference(EndpointReferenceType value) {
		this.jaxbTypeObj.setPublisherRegistrationReference(EndpointReferenceTypeImpl.toJaxbModel(value));
	}
	
	@Override
	public EndpointReferenceType getConsumerReference() {
		EndpointReferenceType consumerRef = null;
		com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType jaxbEndpointRef = 
			this.jaxbTypeObj.getConsumerReference();
		if (jaxbEndpointRef != null){
			consumerRef = WsaUtils.fromJaxbModelEndpointToApiEndpoint(jaxbEndpointRef, this.getClass());
		}
		return consumerRef ;
	}

	@Override
	public final void setConsumerReference(EndpointReferenceType value) {
		this.jaxbTypeObj.setConsumerReference(EndpointReferenceTypeImpl.toJaxbModel(value));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.notification.brokered.RegisterPublisherResponse}
	 *  "Jaxb model type" object from a {@link RegisterPublisherResponse} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse toJaxbModel(RegisterPublisherResponse apiTypeObj) {

		com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse jaxbTypeObj = null;
		
		if (apiTypeObj instanceof RegisterPublisherResponseImpl){
			jaxbTypeObj = ((RegisterPublisherResponseImpl)apiTypeObj).getJaxbTypeObj();
		} else { 
			jaxbTypeObj = WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createRegisterPublisherResponse();
			
			// ~~~~ set RegistrationReference ~~~~
			EndpointReferenceType apiRegistrationRef = apiTypeObj.getPublisherRegistrationReference();
			if (apiRegistrationRef != null){
				jaxbTypeObj.setPublisherRegistrationReference(EndpointReferenceTypeImpl.toJaxbModel(apiRegistrationRef));
			}
			// ~~~~ set ConsumerReference ~~~~
			EndpointReferenceType apiConsumerRef = apiTypeObj.getConsumerReference();
			if (apiConsumerRef != null){
				jaxbTypeObj.setConsumerReference(EndpointReferenceTypeImpl.toJaxbModel(apiConsumerRef));
			}
		}
		return jaxbTypeObj;
	}
	
}
