/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.WsnbrJAXBContext;

/**
 * @author Thierry DÉJEAN - eBM WebSourcing
 */
public class ResourceNotDestroyedFaultTypeImpl extends BaseFaultTypeImpl
		implements ResourceNotDestroyedFaultType {
	
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link ResourceNotDestroyedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected ResourceNotDestroyedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(ResourceNotDestroyedFaultTypeImpl.class.getSimpleName()));
		
		com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType jaxbTypeObj = 
			new com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected ResourceNotDestroyedFaultTypeImpl(com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(ResourceNotDestroyedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType}
	 *  "Jaxb model type" object from a {@link ResourceNotDestroyedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType toJaxbModel(ResourceNotDestroyedFaultType apiTypeObj){

		com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof ResourceNotDestroyedFaultTypeImpl) {
			jaxbTypeObj = (com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType)
			((ResourceNotDestroyedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbrJAXBContext.WSNBR_JAXB_FACTORY.createResourceNotDestroyedFaultType());
		}
		return jaxbTypeObj;
	}
}
