/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;


import java.util.Date;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistration;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.NotificationBrokerRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrReader;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrWriter;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.implementor.WsnbrModelFactory;

/**
 * @author Thierry DÉJEAN - eBM WebSourcing
 */
public class WsnbrModelFactoryImpl implements WsnbrModelFactory {
	
	private WsnbrReaderImpl wsnbrModelReader;
	private WsnbrWriterImpl wsnbrModelWriter;
	
	public WsnbrModelFactoryImpl() {
		this.wsnbrModelReader = new WsnbrReaderImpl();
		this.wsnbrModelWriter = new WsnbrWriterImpl();
	}
	@Override
	public final DestroyRegistration createWsnbrModelDestroyRegistration() {
		return new DestroyRegistrationImpl();
	}

	@Override
	public final DestroyRegistrationResponse createWsnbrModelDestroyRegistrationResponse() {
		return new DestroyRegistrationResponseImpl();
	}

	@Override
	public final NotificationBrokerRP createWsnbrModelNotificationBrokerRP(boolean requiresRegistration) {
		return new NotificationBrokerRPImpl(requiresRegistration);
	}

	@Override
	public final PublisherRegistrationFailedFaultType createWsnbrModelPublisherRegistrationFailedFaultType(
			Date timestamp) {
		return new PublisherRegistrationFailedFaultTypeImpl(timestamp);
	}

	@Override
	public final PublisherRegistrationRejectedFaultType createWsnbrModelPublisherRegistrationRejectedFaultType(
			Date timestamp) {
		return new PublisherRegistrationRejectedFaultTypeImpl(timestamp);
	}

	@Override
	public final PublisherRegistrationRP createWsnbrModelPublisherRegistrationRP(boolean isDemand) {
		return new PublisherRegistrationRPImpl(isDemand);
	}

	@Override
	public final RegisterPublisher createWsnbrModelRegisterPublisher() {
		return new RegisterPublisherImpl();
	}

	@Override
	public final RegisterPublisherResponse createWsnbrModelRegisterPublisherResponse(EndpointReferenceType registrationRef) {
		return new RegisterPublisherResponseImpl(registrationRef);
	}

	@Override
	public final ResourceNotDestroyedFaultType createWsnbrModelResourceNotDestroyedFaultType(
			Date timestamp) {
		return new ResourceNotDestroyedFaultTypeImpl(timestamp);
	}

	@Override
	public final WsnbrReader getWsnbrModelReader() {
		return this.wsnbrModelReader;
	}

	@Override
	public final WsnbrWriter getWsnbrModelWriter() {
		return this.wsnbrModelWriter;
	}

}
