/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.WsnbrConstants;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistration;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.NotificationBrokerRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationFailedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.PublisherRegistrationRejectedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisher;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.ResourceNotDestroyedFaultType;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.abstraction.WsnbrReader;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.api.utils.WsnbrException;
import com.ebmwebsourcing.wsstar.brokerednotification.datatypes.impl.WsnbrJAXBContext;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonException;
import com.ebmwebsourcing.wsstar.common.utils.WsstarCommonUtils;

/**
 * @author Thierry DÉJEAN - eBM WebSourcing
 */
public class WsnbrReaderImpl implements WsnbrReader {
	
	private WsnbrJAXBContext wsnbrJaxbContext = null;
//	private Logger logger = Logger.getLogger(WsnbrReaderImpl.class.getName());
		
	/**
	 * Default constructor
	 */
	protected WsnbrReaderImpl() {
		this.wsnbrJaxbContext = WsnbrJAXBContext.getInstance();
	}
	protected WsnbrReaderImpl(String[] nsAndPrefixForMarshalling) {
		this.wsnbrJaxbContext = WsnbrJAXBContext.getInstance(nsAndPrefixForMarshalling);
	}
	@Override
	public final DestroyRegistration readDestroyRegistration(Document document)
			throws WsnbrException {
		DestroyRegistration result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();
						
            // ------- unmarshall ------
            final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistration> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistration.class);
			result = new DestroyRegistrationImpl(schemaBinding.getValue());
						
		} catch (JAXBException e) {			
			throw new WsnbrException(e);
		} 		
		return result;
	}

	@Override
	public final DestroyRegistrationResponse readDestroyRegistrationResponse(
			Document document) throws WsnbrException {
		DestroyRegistrationResponse result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();
						
            // ------- unmarshall ------
            final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistrationResponse> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.DestroyRegistrationResponse.class);
			result = new DestroyRegistrationResponseImpl(schemaBinding.getValue());
						
		} catch (JAXBException e) {			
			throw new WsnbrException(e);
		} 		
		return result;
	}

	@Override
	public final NotificationBrokerRP readNotificationBrokerRP(Document document)
			throws WsnbrException {
		NotificationBrokerRP result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on Topic nodes
			Map<Integer,List<String[]>> additionalTopicNSPerMsg = new HashMap<Integer,List<String[]>>();
            NodeList topicExprNodes = document.getDocumentElement().getElementsByTagNameNS(
                    WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI(),
                    WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart());
            
            Element currentTopicNode = null;
            for (int i = 0; i < topicExprNodes.getLength(); i++) {            	
            		currentTopicNode = (Element) topicExprNodes.item(0);
            		additionalTopicNSPerMsg.put(i,this.getAdditionalNamespacesFromDom(currentTopicNode));
            }
            
            // Unmarshall to Java Object
            final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.NotificationBrokerRP> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.NotificationBrokerRP.class);
			result = new NotificationBrokerRPImpl(schemaBinding.getValue());

			// Trick : add previously saved namespaces to the created JaxB model
			// (will be used on the write process)     			
			List<TopicExpressionType> topicExpressions = result.getTopicExpressions();
			for (TopicExpressionType topExprItem : topicExpressions) {
				List<String[]> topicNSToAdd = additionalTopicNSPerMsg.get(topicExpressions.indexOf(topExprItem));
				if (topicNSToAdd != null){
					for (String[] currentNs : topicNSToAdd) {
						topExprItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
					}
				}
			}

		} catch (JAXBException e) {			
			throw new WsnbrException(e);
		} catch (URISyntaxException e) {
			throw new WsnbrException(e);
		}                   		

		return result;

	}

	@Override
	public final PublisherRegistrationFailedFaultType readPublisherRegistrationFailedFaultType(
			Document document) throws WsnbrException {
		PublisherRegistrationFailedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationFailedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new PublisherRegistrationFailedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbrException(e);
		} 	
		return result;
	}

	@Override
	public final PublisherRegistrationRejectedFaultType readPublisherRegistrationRejectedFaultType(
			Document document) throws WsnbrException {
		PublisherRegistrationRejectedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRejectedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRejectedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new PublisherRegistrationRejectedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbrException(e);
		} 	
		return result;
	}

	@Override
	public final PublisherRegistrationRP readPublisherRegistrationRP(Document document)
			throws WsnbrException {
		PublisherRegistrationRP result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on Topic nodes
            Map<Integer,List<String[]>> additionalTopicNSs = new HashMap<Integer,List<String[]>>();

            NodeList topicNodes = document.getDocumentElement().getElementsByTagNameNS(
            		WsnbrConstants.TOPIC_QNAME.getNamespaceURI(),
            		WsnbrConstants.TOPIC_QNAME.getLocalPart());
            
            Element currentTopicExpressionAsElt = null;
            for (int i = 0; i < topicNodes.getLength(); i++) {
            	currentTopicExpressionAsElt = (Element) topicNodes.item(i);            	
            	additionalTopicNSs.put(i,this.getAdditionalNamespacesFromDom(currentTopicExpressionAsElt));
            }		
            
            // ------- unmarshall ------
            final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRP> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.PublisherRegistrationRP.class);
			result = new PublisherRegistrationRPImpl(schemaBinding.getValue());
			
			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)       
			List<TopicExpressionType> topics = result.getTopics();
			if (topics!= null){
				for (TopicExpressionType topicItem : topics) {
					for (String[] currentNs : additionalTopicNSs.get(topics.indexOf(topicItem))) {
						topicItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
					}
				}				
			}
		} catch (JAXBException e) {			
			throw new WsnbrException(e);
		} catch (URISyntaxException e) {
			throw new WsnbrException(e);
		} 		
		return result;
	}

	@Override
	public final PublisherRegistrationRP readPublisherRegistrationRP(File file) throws WsnbrException {
		PublisherRegistrationRP registrationObj=null;
		try {
			Document subscriptionAsDoc = WsstarCommonUtils.convertFromFiletoDocument(file);
			registrationObj = this.readPublisherRegistrationRP(subscriptionAsDoc);
		} catch (WsstarCommonException e) {
			throw new WsnbrException(e);
		}
		return registrationObj;
	}

	@Override
	public final RegisterPublisher readRegisterPublisher(Document document)
			throws WsnbrException {
		RegisterPublisher result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on Topic nodes
            Map<Integer,List<String[]>> additionalTopicNSs = new HashMap<Integer,List<String[]>>();

            NodeList topicNodes = document.getDocumentElement().getElementsByTagNameNS(
            		WsnbrConstants.TOPIC_QNAME.getNamespaceURI(),
            		WsnbrConstants.TOPIC_QNAME.getLocalPart());
            
            Element currentTopicExpressionAsElt = null;
            for (int i = 0; i < topicNodes.getLength(); i++) {
            	currentTopicExpressionAsElt = (Element) topicNodes.item(i);            	
            	additionalTopicNSs.put(i,this.getAdditionalNamespacesFromDom(currentTopicExpressionAsElt));
            }		
            
            // ------- unmarshall ------
            final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisher.class);
			result = new RegisterPublisherImpl(schemaBinding.getValue());
			
			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)       
			List<TopicExpressionType> topics = result.getTopics();
			if (topics!= null){
				for (TopicExpressionType topicItem : topics) {
					for (String[] currentNs : additionalTopicNSs.get(topics.indexOf(topicItem))) {
						topicItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
					}
				}				
			}
		} catch (JAXBException e) {			
			throw new WsnbrException(e);
		} catch (URISyntaxException e) {
			throw new WsnbrException(e);
		} 		
		return result;
	}

	@Override
	public final RegisterPublisherResponse readRegisterPublisherResponse(
			Document document) throws WsnbrException {
		RegisterPublisherResponse result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();
						
            // ------- unmarshall ------
            final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.RegisterPublisherResponse.class);
			result = new RegisterPublisherResponseImpl(schemaBinding.getValue());
						
		} catch (JAXBException e) {			
			throw new WsnbrException(e);
		} 		
		return result;
	}

	@Override
	public final ResourceNotDestroyedFaultType readResourceNotDestroyedFaultType(
			Document document) throws WsnbrException {
		ResourceNotDestroyedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbrJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),com.ebmwebsourcing.wsstar.jaxb.notification.brokered.ResourceNotDestroyedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new ResourceNotDestroyedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbrException(e);
		} 	
		return result;
	}
	
	/**
	 * Private method used to extract AdditionalNamespaces
	 * 
	 * @param topicExpressionNode
	 * @return
	 */
	private List<String[]> getAdditionalNamespacesFromDom(org.w3c.dom.Element topicExpressionNode) {
		List<String[]> additionalNamespaces = new ArrayList<String[]>();
		NamedNodeMap nnm = topicExpressionNode.getAttributes();
		for (int i = 0; i < nnm.getLength(); ++i) {
			Node attribute = nnm.item(i);
			if (XMLConstants.XMLNS_ATTRIBUTE.equals(attribute.getPrefix())) {
				// It's an namespace declaration attribute
				additionalNamespaces.add(new String[] { attribute.getLocalName(),
						attribute.getNodeValue() });
			}
		}
		return additionalNamespaces;
	}
}
